/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;

public class StarTreeV2Metadata {
    private final int _numDocs;
    private final List<String> _dimensionsSplitOrder;
    private final Set<AggregationFunctionColumnPair> _functionColumnPairs;
    private final int _maxLeafRecords;
    private final Set<String> _skipStarNodeCreationForDimensions;

    public StarTreeV2Metadata(int numDocs, List<String> dimensionsSplitOrder, Set<AggregationFunctionColumnPair> functionColumnPairs, int maxLeafRecords, Set<String> skipStarNodeCreationForDimensions) {
        this._numDocs = numDocs;
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._functionColumnPairs = functionColumnPairs;
        this._maxLeafRecords = maxLeafRecords;
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
    }

    public StarTreeV2Metadata(Configuration metadataProperties) {
        this._numDocs = metadataProperties.getInt("total.docs");
        this._dimensionsSplitOrder = metadataProperties.getList("split.order");
        this._functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        for (Object functionColumnPair : metadataProperties.getList("function.column.pairs")) {
            this._functionColumnPairs.add(AggregationFunctionColumnPair.fromColumnName((String)functionColumnPair));
        }
        this._maxLeafRecords = metadataProperties.getInt("max.leaf.records");
        this._skipStarNodeCreationForDimensions = new HashSet<String>(metadataProperties.getList("skip.star.node.creation"));
    }

    public int getNumDocs() {
        return this._numDocs;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    public boolean containsFunctionColumnPair(AggregationFunctionColumnPair functionColumnPair) {
        return this._functionColumnPairs.contains(functionColumnPair);
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }
}

