/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeLoaderUtils;
import org.apache.pinot.common.segment.ReadMode;

public class StarTreeIndexContainer
implements Closeable {
    private final PinotDataBuffer _dataBuffer;
    private final List<StarTreeV2> _starTrees;

    public StarTreeIndexContainer(File segmentDirectory, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap, ReadMode readMode) throws ConfigurationException, IOException {
        List<StarTreeV2Metadata> starTreeMetadataList = segmentMetadata.getStarTreeV2MetadataList();
        if (starTreeMetadataList != null) {
            File indexFile = new File(segmentDirectory, "star_tree_index");
            this._dataBuffer = readMode == ReadMode.heap ? PinotDataBuffer.loadFile(indexFile, 0L, indexFile.length(), ByteOrder.LITTLE_ENDIAN, "Star-tree V2 data buffer") : PinotDataBuffer.mapFile(indexFile, true, 0L, indexFile.length(), ByteOrder.LITTLE_ENDIAN, "Star-tree V2 data buffer");
            File indexMapFile = new File(segmentDirectory, "star_tree_index_map");
            List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMapList = StarTreeIndexMapUtils.loadFromFile(indexMapFile, starTreeMetadataList.size());
            this._starTrees = StarTreeLoaderUtils.loadStarTreeV2(this._dataBuffer, indexMapList, segmentMetadata, indexContainerMap);
        } else {
            File indexFile = new File(segmentDirectory, "star-tree.bin");
            this._dataBuffer = readMode == ReadMode.heap ? PinotDataBuffer.loadFile(indexFile, 0L, indexFile.length(), ByteOrder.LITTLE_ENDIAN, "Star-tree V1 data buffer") : PinotDataBuffer.mapFile(indexFile, true, 0L, indexFile.length(), ByteOrder.LITTLE_ENDIAN, "Star-tree V1 data buffer");
            this._starTrees = StarTreeLoaderUtils.convertFromStarTreeV1(this._dataBuffer, segmentMetadata, indexContainerMap);
        }
    }

    public List<StarTreeV2> getStarTrees() {
        return this._starTrees;
    }

    @Override
    public void close() throws IOException {
        this._dataBuffer.close();
    }
}

