/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.pinot.core.common.DataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.data.aggregator.ValueAggregatorFactory;
import org.apache.pinot.$internal.org.apache.pinot.core.query.aggregation.function.AggregationFunctionType;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.ColumnMetadata;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.SegmentMetadataImpl;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.index.data.source.ColumnDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.OffHeapStarTree;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.StarTree;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeDimensionDataSource;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.$internal.org.apache.pinot.core.startree.v2.store.StarTreeMetricDataSource;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.segment.StarTreeMetadata;

public class StarTreeLoaderUtils {
    private StarTreeLoaderUtils() {
    }

    public static List<StarTreeV2> loadStarTreeV2(PinotDataBuffer dataBuffer, List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMapList, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap) {
        List<StarTreeV2Metadata> starTreeMetadataList = segmentMetadata.getStarTreeV2MetadataList();
        int numStarTrees = starTreeMetadataList.size();
        ArrayList<StarTreeV2> starTrees = new ArrayList<StarTreeV2>(numStarTrees);
        for (int i = 0; i < numStarTrees; ++i) {
            Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap = indexMapList.get(i);
            StarTreeIndexMapUtils.IndexValue indexValue = indexMap.get(StarTreeIndexMapUtils.STAR_TREE_INDEX_KEY);
            long start = indexValue._offset;
            long end = start + indexValue._size;
            final OffHeapStarTree starTree = new OffHeapStarTree(dataBuffer.view(start, end, ByteOrder.LITTLE_ENDIAN));
            final StarTreeV2Metadata starTreeMetadata = starTreeMetadataList.get(i);
            int numDocs = starTreeMetadata.getNumDocs();
            final HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
            for (String dimension : starTreeMetadata.getDimensionsSplitOrder()) {
                indexValue = indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, dimension));
                start = indexValue._offset;
                end = start + indexValue._size;
                ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(dimension);
                dataSourceMap.put(dimension, new StarTreeDimensionDataSource(dataBuffer.view(start, end, ByteOrder.BIG_ENDIAN), dimension, numDocs, columnMetadata.getDataType(), indexContainerMap.get(dimension).getDictionary(), columnMetadata.getBitsPerElement(), columnMetadata.getCardinality()));
            }
            for (AggregationFunctionColumnPair functionColumnPair : starTreeMetadata.getFunctionColumnPairs()) {
                String metric = functionColumnPair.toColumnName();
                indexValue = indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, metric));
                start = indexValue._offset;
                end = start + indexValue._size;
                dataSourceMap.put(metric, new StarTreeMetricDataSource(dataBuffer.view(start, end, ByteOrder.BIG_ENDIAN), metric, numDocs, ValueAggregatorFactory.getAggregatedValueType(functionColumnPair.getFunctionType())));
            }
            starTrees.add(new StarTreeV2(){

                @Override
                public StarTree getStarTree() {
                    return starTree;
                }

                @Override
                public StarTreeV2Metadata getMetadata() {
                    return starTreeMetadata;
                }

                @Override
                public DataSource getDataSource(String columnName) {
                    return (DataSource)dataSourceMap.get(columnName);
                }
            });
        }
        return starTrees;
    }

    public static List<StarTreeV2> convertFromStarTreeV1(PinotDataBuffer dataBuffer, final SegmentMetadataImpl segmentMetadata, final Map<String, ColumnIndexContainer> indexContainerMap) {
        final OffHeapStarTree starTree = new OffHeapStarTree(dataBuffer);
        StarTreeMetadata starTreeMetadata = segmentMetadata.getStarTreeMetadata();
        Schema schema = segmentMetadata.getSchema();
        ArrayList<String> dimensionsSplitOrder = new ArrayList<String>(schema.getDimensionNames());
        dimensionsSplitOrder.removeAll(starTreeMetadata.getSkipMaterializationForDimensions());
        HashSet<AggregationFunctionColumnPair> functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        for (MetricFieldSpec metricFieldSpec : schema.getMetricFieldSpecs()) {
            String column = metricFieldSpec.getName();
            if (metricFieldSpec.isDerivedMetric()) {
                assert (metricFieldSpec.getDerivedMetricType() == MetricFieldSpec.DerivedMetricType.HLL);
                functionColumnPairs.add(new AggregationFunctionColumnPair(AggregationFunctionType.FASTHLL, column));
                continue;
            }
            functionColumnPairs.add(new AggregationFunctionColumnPair(AggregationFunctionType.SUM, column));
        }
        final StarTreeV2Metadata starTreeV2Metadata = new StarTreeV2Metadata(segmentMetadata.getTotalDocs(), dimensionsSplitOrder, functionColumnPairs, starTreeMetadata.getMaxLeafRecords(), new HashSet<String>(starTreeMetadata.getSkipStarNodeCreationForDimensions()));
        return Collections.singletonList(new StarTreeV2(){

            @Override
            public StarTree getStarTree() {
                return starTree;
            }

            @Override
            public StarTreeV2Metadata getMetadata() {
                return starTreeV2Metadata;
            }

            @Override
            public DataSource getDataSource(String columnName) {
                String column = columnName.contains("__") ? AggregationFunctionColumnPair.fromColumnName(columnName).getColumn() : columnName;
                return new ColumnDataSource((ColumnIndexContainer)indexContainerMap.get(column), segmentMetadata.getColumnMetadataFor(column));
            }
        });
    }
}

