/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.transport;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.Server;
import org.apache.pinot.$internal.org.apache.pinot.core.transport.ServerResponse;
import org.apache.pinot.common.utils.DataTable;

@ThreadSafe
public class AsyncQueryResponse {
    private final QueryRouter _queryRouter;
    private final long _requestId;
    private final ConcurrentHashMap<Server, ServerResponse> _responseMap;
    private final CountDownLatch _countDownLatch;
    private final long _maxEndTimeMs;

    public AsyncQueryResponse(QueryRouter queryRouter, long requestId, Set<Server> serversQueried, long startTimeMs, long timeoutMs) {
        this._queryRouter = queryRouter;
        this._requestId = requestId;
        int numServersQueried = serversQueried.size();
        this._responseMap = new ConcurrentHashMap(numServersQueried);
        for (Server server : serversQueried) {
            this._responseMap.put(server, new ServerResponse(startTimeMs));
        }
        this._countDownLatch = new CountDownLatch(numServersQueried);
        this._maxEndTimeMs = startTimeMs + timeoutMs;
    }

    public Map<Server, ServerResponse> getResponse() throws InterruptedException {
        try {
            this._countDownLatch.await(this._maxEndTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            ConcurrentHashMap<Server, ServerResponse> concurrentHashMap = this._responseMap;
            return concurrentHashMap;
        }
        finally {
            this._queryRouter.markQueryDone(this._requestId);
        }
    }

    public String getStats() {
        StringBuilder stringBuilder = new StringBuilder("(Server=SubmitDelayMs,ResponseDelayMs,ResponseSize,DeserializationTimeMs)");
        for (Map.Entry<Server, ServerResponse> entry : this._responseMap.entrySet()) {
            stringBuilder.append(';').append(entry.getKey().getShortName()).append('=').append(entry.getValue().toString());
        }
        return stringBuilder.toString();
    }

    void markRequestSubmitted(Server server) {
        this._responseMap.get(server).markRequestSubmitted();
    }

    void receiveDataTable(Server server, DataTable dataTable, long responseSize, long deserializationTimeMs) {
        this._responseMap.get(server).receiveDataTable(dataTable, responseSize, deserializationTimeMs);
        this._countDownLatch.countDown();
    }

    void markQueryFailed() {
        int count = (int)this._countDownLatch.getCount();
        for (int i = 0; i < count; ++i) {
            this._countDownLatch.countDown();
        }
    }

    void markServerDown(Server server) {
        ServerResponse serverResponse = this._responseMap.get(server);
        if (serverResponse != null && serverResponse.getDataTable() == null) {
            this.markQueryFailed();
        }
    }
}

