/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.pinot.core.data.GenericRow;
import org.apache.pinot.common.data.DimensionFieldSpec;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.TimeFieldSpec;

public class AvroUtils {
    private AvroUtils() {
    }

    public static org.apache.pinot.common.data.Schema getPinotSchemaFromAvroSchema(@Nonnull Schema avroSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        org.apache.pinot.common.data.Schema pinotSchema = new org.apache.pinot.common.data.Schema();
        block5: for (Schema.Field field : avroSchema.getFields()) {
            String fieldName = field.name();
            FieldSpec.DataType dataType = AvroUtils.extractFieldDataType(field);
            boolean isSingleValueField = AvroUtils.isSingleValueField(field);
            if (fieldTypeMap == null) {
                pinotSchema.addField(new DimensionFieldSpec(fieldName, dataType, isSingleValueField));
                continue;
            }
            FieldSpec.FieldType fieldType = fieldTypeMap.get(fieldName);
            Preconditions.checkNotNull(fieldType, "Field type not specified for field: %s", (Object)fieldName);
            switch (fieldType) {
                case DIMENSION: {
                    pinotSchema.addField(new DimensionFieldSpec(fieldName, dataType, isSingleValueField));
                    continue block5;
                }
                case METRIC: {
                    Preconditions.checkState(isSingleValueField, "Metric field: %s cannot be multi-valued", (Object)fieldName);
                    pinotSchema.addField(new MetricFieldSpec(fieldName, dataType));
                    continue block5;
                }
                case TIME: {
                    Preconditions.checkState(isSingleValueField, "Time field: %s cannot be multi-valued", (Object)fieldName);
                    Preconditions.checkNotNull(timeUnit, "Time unit cannot be null");
                    pinotSchema.addField(new TimeFieldSpec(field.name(), dataType, timeUnit));
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unsupported field type: " + (Object)((Object)fieldType) + " for field: " + fieldName);
        }
        return pinotSchema;
    }

    public static org.apache.pinot.common.data.Schema getPinotSchemaFromAvroDataFile(@Nonnull File avroDataFile, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) throws IOException {
        try (DataFileStream<GenericRecord> reader = AvroUtils.getAvroReader(avroDataFile);){
            Schema avroSchema = reader.getSchema();
            org.apache.pinot.common.data.Schema schema = AvroUtils.getPinotSchemaFromAvroSchema(avroSchema, fieldTypeMap, timeUnit);
            return schema;
        }
    }

    public static org.apache.pinot.common.data.Schema getPinotSchemaFromAvroDataFile(@Nonnull File avroDataFile) throws IOException {
        return AvroUtils.getPinotSchemaFromAvroDataFile(avroDataFile, null, null);
    }

    public static org.apache.pinot.common.data.Schema getPinotSchemaFromAvroSchemaFile(@Nonnull File avroSchemaFile, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) throws IOException {
        Schema avroSchema = new Schema.Parser().parse(avroSchemaFile);
        return AvroUtils.getPinotSchemaFromAvroSchema(avroSchema, fieldTypeMap, timeUnit);
    }

    public static Schema getAvroSchemaFromPinotSchema(org.apache.pinot.common.data.Schema pinotSchema) {
        SchemaBuilder.FieldAssembler fieldAssembler = SchemaBuilder.record((String)"record").fields();
        block15: for (FieldSpec fieldSpec : pinotSchema.getAllFieldSpecs()) {
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            if (fieldSpec.isSingleValueField()) {
                switch (dataType) {
                    case INT: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().intType().noDefault();
                        continue block15;
                    }
                    case LONG: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().longType().noDefault();
                        continue block15;
                    }
                    case FLOAT: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().floatType().noDefault();
                        continue block15;
                    }
                    case DOUBLE: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().doubleType().noDefault();
                        continue block15;
                    }
                    case STRING: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().stringType().noDefault();
                        continue block15;
                    }
                    case BYTES: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().bytesType().noDefault();
                        continue block15;
                    }
                }
                throw new RuntimeException("Unsupported data type: " + (Object)((Object)dataType));
            }
            switch (dataType) {
                case INT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().intType()).noDefault();
                    continue block15;
                }
                case LONG: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().longType()).noDefault();
                    continue block15;
                }
                case FLOAT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().floatType()).noDefault();
                    continue block15;
                }
                case DOUBLE: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().doubleType()).noDefault();
                    continue block15;
                }
                case STRING: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().stringType()).noDefault();
                    continue block15;
                }
            }
            throw new RuntimeException("Unsupported data type: " + (Object)((Object)dataType));
        }
        return (Schema)fieldAssembler.endRecord();
    }

    public static DataFileStream<GenericRecord> getAvroReader(File avroFile) throws IOException {
        if (avroFile.getName().endsWith(".gz")) {
            return new DataFileStream((InputStream)new GZIPInputStream(new FileInputStream(avroFile)), (DatumReader)new GenericDatumReader());
        }
        return new DataFileStream((InputStream)new FileInputStream(avroFile), (DatumReader)new GenericDatumReader());
    }

    public static boolean isSingleValueField(Schema.Field field) {
        try {
            Schema fieldSchema = AvroUtils.extractSupportedSchema(field.schema());
            return fieldSchema.getType() != Schema.Type.ARRAY;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while extracting non-null schema from field: " + field.name(), e);
        }
    }

    public static FieldSpec.DataType extractFieldDataType(Schema.Field field) {
        try {
            Schema fieldSchema = AvroUtils.extractSupportedSchema(field.schema());
            Schema.Type fieldType = fieldSchema.getType();
            if (fieldType == Schema.Type.ARRAY) {
                return FieldSpec.DataType.valueOf(AvroUtils.extractSupportedSchema(fieldSchema.getElementType()).getType());
            }
            return FieldSpec.DataType.valueOf(fieldType);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while extracting data type from field: " + field.name(), e);
        }
    }

    private static Schema extractSupportedSchema(Schema fieldSchema) {
        Schema.Type fieldType = fieldSchema.getType();
        if (fieldType == Schema.Type.UNION) {
            Schema nonNullSchema = null;
            for (Schema childFieldSchema : fieldSchema.getTypes()) {
                if (childFieldSchema.getType() == Schema.Type.NULL) continue;
                if (nonNullSchema == null) {
                    nonNullSchema = childFieldSchema;
                    continue;
                }
                throw new IllegalStateException("More than one non-null schema in UNION schema");
            }
            if (nonNullSchema != null) {
                return AvroUtils.extractSupportedSchema(nonNullSchema);
            }
            throw new IllegalStateException("Cannot find non-null schema in UNION schema");
        }
        if (fieldType == Schema.Type.RECORD) {
            List recordFields = fieldSchema.getFields();
            Preconditions.checkState(recordFields.size() == 1, "Not one field in the RECORD schema");
            return AvroUtils.extractSupportedSchema(((Schema.Field)recordFields.get(0)).schema());
        }
        return fieldSchema;
    }

    public static void fillGenericRow(GenericRecord from, GenericRow to, org.apache.pinot.common.data.Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            String fieldName = fieldSpec.getName();
            Object avroValue = from.get(fieldName);
            if (fieldSpec.isSingleValueField()) {
                to.putField(fieldName, AvroUtils.transformAvroValueToObject(avroValue, fieldSpec));
                continue;
            }
            to.putField(fieldName, AvroUtils.transformAvroArrayToObjectArray((GenericData.Array)avroValue, fieldSpec));
        }
    }

    public static Object transformAvroValueToObject(Object avroValue, FieldSpec fieldSpec) {
        if (avroValue == null) {
            return fieldSpec.getDefaultNullValue();
        }
        if (avroValue instanceof GenericData.Record) {
            return AvroUtils.transformAvroValueToObject(((GenericData.Record)avroValue).get(0), fieldSpec);
        }
        if (fieldSpec.getDataType() == FieldSpec.DataType.STRING) {
            return avroValue.toString();
        }
        if (fieldSpec.getDataType() == FieldSpec.DataType.BYTES && avroValue instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)avroValue;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return avroValue;
    }

    public static Object[] transformAvroArrayToObjectArray(GenericData.Array avroArray, FieldSpec fieldSpec) {
        if (avroArray == null || avroArray.size() == 0) {
            return new Object[]{fieldSpec.getDefaultNullValue()};
        }
        int numValues = avroArray.size();
        Object[] objects = new Object[numValues];
        for (int i = 0; i < numValues; ++i) {
            objects[i] = AvroUtils.transformAvroValueToObject(avroArray.get(i), fieldSpec);
        }
        return objects;
    }
}

