/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.util;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public abstract class BaseIndexedPriorityQueue {
    protected boolean _minHeap;
    protected Int2IntOpenHashMap _keyToIndexMap;
    protected Int2IntOpenHashMap _indexToKeyMap;

    public BaseIndexedPriorityQueue(int initialCapacity, boolean minHeap) {
        this._minHeap = minHeap;
        this._keyToIndexMap = new Int2IntOpenHashMap(initialCapacity);
        this._indexToKeyMap = new Int2IntOpenHashMap(initialCapacity);
    }

    protected void updateKeyIndexMap(int key, int position) {
        this._keyToIndexMap.put(key, position);
        this._indexToKeyMap.put(position, key);
    }

    protected void swapKeys(int index1, int index2) {
        int key1 = this._indexToKeyMap.get(index1);
        int key2 = this._indexToKeyMap.get(index2);
        this.updateKeyIndexMap(key1, index2);
        this.updateKeyIndexMap(key2, index1);
    }

    protected int getLeftChildIndex(int index) {
        return 2 * (index + 1) - 1;
    }

    protected int getRightChildIndex(int index) {
        return 2 * (index + 1);
    }

    protected int getParentIndex(int index) {
        return (index + 1) / 2 - 1;
    }
}

