/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.Adler32;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;

public class CrcUtils {
    private static final int BUFFER_SIZE = 65536;
    private final List<File> _files;

    private CrcUtils(List<File> files) {
        this._files = files;
    }

    public static CrcUtils forAllFilesInFolder(File dir) {
        ArrayList<File> normalFiles = new ArrayList<File>();
        CrcUtils.getAllNormalFiles(dir, normalFiles);
        Collections.sort(normalFiles);
        return new CrcUtils(normalFiles);
    }

    private static void getAllNormalFiles(File dir, List<File> normalFiles) {
        File[] files = dir.listFiles();
        Preconditions.checkNotNull(files);
        for (File file : files) {
            if (file.isFile()) {
                if (file.getName().equals("creation.meta")) continue;
                normalFiles.add(file);
                continue;
            }
            CrcUtils.getAllNormalFiles(file, normalFiles);
        }
    }

    public long computeCrc() throws IOException {
        byte[] buffer = new byte[65536];
        Adler32 checksum = new Adler32();
        for (File file : this._files) {
            FileInputStream input = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int len;
                while ((len = ((InputStream)input).read(buffer)) > 0) {
                    checksum.update(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)input).close();
            }
        }
        return checksum.getValue();
    }

    public String computeMD5() throws NoSuchAlgorithmException, IOException {
        byte[] buffer = new byte[65536];
        MessageDigest digest = MessageDigest.getInstance("md5");
        for (File file : this._files) {
            FileInputStream input = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int len;
                while ((len = ((InputStream)input).read(buffer)) > 0) {
                    digest.update(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)input).close();
            }
        }
        return CrcUtils.toHexaDecimal(digest.digest());
    }

    public static String toHexaDecimal(byte[] bytesToConvert) {
        char[] hexCharactersAsArray = "0123456789ABCDEF".toCharArray();
        char[] convertedHexCharsArray = new char[bytesToConvert.length * 2];
        for (int j = 0; j < bytesToConvert.length; ++j) {
            int v = bytesToConvert[j] & 0xFF;
            convertedHexCharsArray[j * 2] = hexCharactersAsArray[v >>> 4];
            convertedHexCharsArray[j * 2 + 1] = hexCharactersAsArray[v & 0xF];
        }
        return new String(convertedHexCharsArray);
    }
}

