/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.core.util;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.$internal.org.apache.pinot.core.io.readerwriter.impl.FixedByteSingleValueMultiColumnReaderWriter;
import org.apache.pinot.$internal.org.apache.pinot.core.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.$internal.org.apache.pinot.core.util.FixedIntArray;
import org.apache.pinot.$internal.org.apache.pinot.core.util.IdMap;
import org.apache.pinot.common.Utils;

public class FixedIntArrayOffHeapIdMap
extends BaseOffHeapMutableDictionary
implements IdMap<FixedIntArray> {
    private final FixedByteSingleValueMultiColumnReaderWriter _dictIdToValue;
    private final int _numColumns;

    public FixedIntArrayOffHeapIdMap(int estimatedCardinality, int maxOverflowHashSize, int numColumns, PinotDataBufferMemoryManager memoryManager, String allocationContext) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        int initialSize = this.nearestPowerOf2(estimatedCardinality);
        int[] columnSizesInBytes = new int[numColumns];
        Arrays.fill(columnSizesInBytes, 4);
        this._dictIdToValue = new FixedByteSingleValueMultiColumnReaderWriter(initialSize, columnSizesInBytes, memoryManager, allocationContext);
        this._numColumns = numColumns;
    }

    @Override
    public int put(FixedIntArray fixedIntArray) {
        this.index(fixedIntArray);
        return this.indexOf(fixedIntArray);
    }

    @Override
    public int getId(FixedIntArray fixedIntArray) {
        int id = this.indexOf(fixedIntArray);
        return id != -1 ? id : -1;
    }

    @Override
    public FixedIntArray getKey(int id) {
        return (FixedIntArray)this.get(id);
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public void clear() {
        try {
            this.close();
            this.init();
        }
        catch (IOException e) {
            Utils.rethrowException(e);
        }
    }

    @Override
    public Object get(int dictId) {
        int[] value = new int[this._numColumns];
        for (int col = 0; col < this._numColumns; ++col) {
            value[col] = this._dictIdToValue.getInt(dictId, col);
        }
        return new FixedIntArray(value);
    }

    @Override
    public int indexOf(Object rawValue) {
        return this.getDictId(rawValue, null);
    }

    @Override
    public void doClose() throws IOException {
        this._dictIdToValue.close();
    }

    @Override
    protected void setRawValueAt(int dictId, Object value, byte[] serializedValue) {
        FixedIntArray intArray = (FixedIntArray)value;
        int[] values = intArray.elements();
        for (int col = 0; col < values.length; ++col) {
            this._dictIdToValue.setInt(dictId, col, values[col]);
        }
    }

    @Override
    public void index(@Nonnull Object value) {
        this.indexValue(value, null);
    }

    @Override
    public boolean inRange(@Nonnull String lower, @Nonnull String upper, int dictIdToCompare, boolean includeLower, boolean includeUpper) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Object getMinVal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Object getMaxVal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Object getSortedValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAvgValueSize() {
        throw new UnsupportedOperationException();
    }
}

