/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class BetweenPredicateAstNode
extends PredicateAstNode {
    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            IdentifierAstNode node = (IdentifierAstNode)childNode;
            this._identifier = node.getName();
        } else if (childNode instanceof FunctionCallAstNode) {
            this._function = (FunctionCallAstNode)childNode;
        } else {
            super.addChild(childNode);
        }
    }

    public String getLeftValue() {
        return ((LiteralAstNode)this.getChildren().get(0)).getValueAsString();
    }

    public String getRightValue() {
        return ((LiteralAstNode)this.getChildren().get(1)).getValueAsString();
    }

    @Override
    public String toString() {
        if (this._identifier != null) {
            return "BetweenPredicateAstNode{_identifier='" + this._identifier + '\'' + '}';
        }
        if (this._function != null) {
            return "BetweenPredicateAstNode{_function='" + this._function.toString() + '\'' + '}';
        }
        return "BetweenPredicateAstNode{_identifier/_function= null}";
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("Between predicate has no identifier");
        }
        if (this.getChildren().size() == 2) {
            try {
                LiteralAstNode left = (LiteralAstNode)this.getChildren().get(0);
                LiteralAstNode right = (LiteralAstNode)this.getChildren().get(1);
                return new FilterQueryTree(this._identifier, Collections.singletonList("[" + left.getValueAsString() + "\t\t" + right.getValueAsString() + "]"), FilterOperator.RANGE, null);
            }
            catch (ClassCastException e) {
                throw new Pql2CompilationException("BETWEEN clause was expecting two literal AST nodes, got " + this.getChildren().get(0) + " and " + this.getChildren().get(1));
            }
        }
        throw new Pql2CompilationException("BETWEEN clause does not have two children nodes");
    }

    @Override
    public HavingQueryTree buildHavingQueryTree() {
        if (this._function == null) {
            throw new Pql2CompilationException("Between predicate has no function call specified");
        }
        if (this.getChildren().size() == 2) {
            try {
                LiteralAstNode left = (LiteralAstNode)this.getChildren().get(0);
                LiteralAstNode right = (LiteralAstNode)this.getChildren().get(1);
                return new HavingQueryTree(this._function.buildAggregationInfo(), Collections.singletonList("[" + left.getValueAsString() + "\t\t" + right.getValueAsString() + "]"), FilterOperator.RANGE, null);
            }
            catch (ClassCastException e) {
                throw new Pql2CompilationException("BETWEEN clause was expecting two literal AST nodes, got " + this.getChildren().get(0) + " and " + this.getChildren().get(1));
            }
        }
        throw new Pql2CompilationException("BETWEEN clause does not have two children nodes");
    }
}

