/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.BaseAstNode;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.transform.TransformExpressionTree;
import org.apache.pinot.common.utils.EqualityUtils;

public class FunctionCallAstNode
extends BaseAstNode {
    private final String _name;
    private String _expression;
    private boolean _isInSelectList;

    public FunctionCallAstNode(String name, String expression) {
        this._name = name;
        this._expression = expression;
        this._isInSelectList = true;
    }

    public boolean equals(Object obj) {
        if (EqualityUtils.isNullOrNotSameClass(this, obj)) {
            return false;
        }
        if (EqualityUtils.isSameReference(this, obj)) {
            return true;
        }
        FunctionCallAstNode functionCallAstNode = (FunctionCallAstNode)obj;
        return this._name.equals(functionCallAstNode.getName()) && this._expression.equals(functionCallAstNode.getExpression());
    }

    public int hashCode() {
        int hashCode = EqualityUtils.hashCodeOf(this._name);
        hashCode = EqualityUtils.hashCodeOf(hashCode, this._expression);
        hashCode = EqualityUtils.hashCodeOf(hashCode, this._isInSelectList);
        return hashCode;
    }

    public void setIsInSelectList(boolean value) {
        this._isInSelectList = value;
    }

    public String getName() {
        return this._name;
    }

    public String getExpression() {
        return this._expression;
    }

    public AggregationInfo buildAggregationInfo() {
        String expression;
        if (this._name.equalsIgnoreCase("count")) {
            expression = "*";
        } else {
            List<? extends AstNode> children = this.getChildren();
            if (children == null || children.size() != 1) {
                throw new Pql2CompilationException("Aggregation function expects exact 1 argument");
            }
            expression = TransformExpressionTree.getStandardExpression(children.get(0));
        }
        AggregationInfo aggregationInfo = new AggregationInfo();
        aggregationInfo.setAggregationType(this._name);
        aggregationInfo.putToAggregationParams("column", expression);
        aggregationInfo.setIsInSelectList(this._isInSelectList);
        return aggregationInfo;
    }

    @Override
    public String toString() {
        return "FunctionCallAstNode{_name='" + this._name + '\'' + '}';
    }
}

