/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.Pql2CompilationException;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.$internal.org.apache.pinot.pql.parsers.pql2.ast.PredicateAstNode;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.HavingQueryTree;

public class RegexpLikePredicateAstNode
extends PredicateAstNode {
    private static final String SEPERATOR = "\t\t";
    private String _identifier;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addChild(AstNode childNode) {
        if (childNode instanceof IdentifierAstNode) {
            if (this._identifier != null) throw new Pql2CompilationException("REGEXP_LIKE predicate has more than one identifier.");
            IdentifierAstNode node = (IdentifierAstNode)childNode;
            this._identifier = node.getName();
            return;
        } else {
            if (childNode instanceof FunctionCallAstNode) {
                throw new Pql2CompilationException("REGEXP_LIKE operator can not be called for a function.");
            }
            super.addChild(childNode);
        }
    }

    @Override
    public FilterQueryTree buildFilterQueryTree() {
        if (this._identifier == null) {
            throw new Pql2CompilationException("REGEXP_LIKE predicate has no identifier");
        }
        HashSet<String> values = new HashSet<String>();
        for (AstNode astNode : this.getChildren()) {
            if (!(astNode instanceof LiteralAstNode)) continue;
            LiteralAstNode node = (LiteralAstNode)astNode;
            String expr = node.getValueAsString();
            values.add(expr);
        }
        if (values.size() > 1) {
            throw new Pql2CompilationException("Matching more than one regex is NOT supported currently");
        }
        String[] valueArray = values.toArray(new String[values.size()]);
        FilterOperator filterOperator = FilterOperator.REGEXP_LIKE;
        List<String> value = Collections.singletonList(StringUtil.join(SEPERATOR, valueArray));
        return new FilterQueryTree(this._identifier, value, filterOperator, null);
    }

    @Override
    public HavingQueryTree buildHavingQueryTree() {
        throw new Pql2CompilationException("REGEXP_LIKE predicate is not supported in HAVING clause.");
    }
}

