/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.AbstractCompositeListenableFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeFuture<V>
extends AbstractCompositeListenableFuture<V> {
    protected static Logger LOGGER = LoggerFactory.getLogger(CompositeFuture.class);
    private final Collection<ServerResponseFuture<V>> _futures;
    private final ConcurrentMap<ServerInstance, V> _delayedResponseMap;
    private final ConcurrentMap<ServerInstance, Long> _responseTimeMap = new ConcurrentHashMap<ServerInstance, Long>(10);
    private final ConcurrentMap<ServerInstance, Throwable> _errorMap;
    private final GatherModeOnError _gatherMode;
    private final String _name;

    public CompositeFuture(String name, GatherModeOnError mode) {
        this._name = name;
        this._futures = new ArrayList<ServerResponseFuture<V>>();
        this._delayedResponseMap = new ConcurrentHashMap<ServerInstance, V>();
        this._errorMap = new ConcurrentHashMap<ServerInstance, Throwable>();
        this._gatherMode = mode;
    }

    public void start(Collection<ServerResponseFuture<V>> futureList) {
        boolean started = super.start();
        if (!started) {
            String msg = "Unable to start the future. State is already : " + (Object)((Object)this._state);
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
        if (null != futureList) {
            this._futures.addAll(futureList);
            this._latch = new CountDownLatch(futureList.size());
        } else {
            this._latch = new CountDownLatch(0);
        }
        for (ServerResponseFuture<V> entry : this._futures) {
            if (null == entry) continue;
            this.addResponseFutureListener(entry);
        }
    }

    @Override
    protected void cancelUnderlyingFutures() {
        LOGGER.info("Cancelling all underlying futures for {}", (Object)this.getName());
        for (ServerResponseFuture<V> entry : this._futures) {
            LOGGER.info("Cancelling future {}", (Object)entry.getName());
            entry.cancel(true);
        }
    }

    @Override
    public Map<ServerInstance, V> get() throws InterruptedException, ExecutionException {
        this._latch.await();
        return this._delayedResponseMap;
    }

    @Override
    public V getOne() throws InterruptedException, ExecutionException {
        this._latch.await();
        if (this._delayedResponseMap.isEmpty()) {
            return null;
        }
        return this._delayedResponseMap.values().iterator().next();
    }

    @Override
    public V getOne(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean notElapsed = this._latch.await(timeout, unit);
        if (!notElapsed) {
            throw new TimeoutException("Timedout waiting for async result for composite ");
        }
        if (this._delayedResponseMap.isEmpty()) {
            return null;
        }
        return this._delayedResponseMap.values().iterator().next();
    }

    @Override
    public Map<ServerInstance, Throwable> getError() {
        return this._errorMap;
    }

    @Override
    public long getDurationMillis() {
        long maxDuration = -1L;
        for (Map.Entry entry : this._responseTimeMap.entrySet()) {
            if ((Long)entry.getValue() <= maxDuration) continue;
            maxDuration = (Long)entry.getValue();
        }
        return maxDuration;
    }

    @Override
    public Map<ServerInstance, V> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this._latch.await(timeout, unit);
        return this._delayedResponseMap;
    }

    public Map<ServerInstance, Long> getResponseTimes() {
        return Collections.unmodifiableMap(this._responseTimeMap);
    }

    @Override
    public ServerInstance getServerInstance() {
        throw new RuntimeException("Invalid API call on a composite future");
    }

    @Override
    protected boolean processFutureResult(ServerInstance server, Map<ServerInstance, V> response, Map<ServerInstance, Throwable> error, long durationMillis) {
        boolean ret = false;
        if (null != response) {
            LOGGER.debug("Response from {} is {}", (Object)server, response);
            this._delayedResponseMap.putAll(response);
        } else if (null != error) {
            LOGGER.debug("Error from {} is : {}", (Object)server, error);
            this._errorMap.putAll(error);
            if (this._gatherMode == GatherModeOnError.SHORTCIRCUIT_AND) {
                ret = true;
            }
        }
        this._responseTimeMap.put(server, durationMillis);
        return ret;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int getNumFutures() {
        return this._futures.size();
    }

    public static enum GatherModeOnError {
        SHORTCIRCUIT_AND,
        AND;

    }
}

