/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.AbstractCompositeListenableFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectingFuture<T>
extends AbstractCompositeListenableFuture<T> {
    protected static Logger LOGGER = LoggerFactory.getLogger(SelectingFuture.class);
    private final List<ServerResponseFuture<T>> _futuresList;
    private volatile Map<ServerInstance, T> _delayedResponse;
    private volatile Map<ServerInstance, Throwable> _error;
    private final String _name;
    private long _durationMillis = -1L;

    public SelectingFuture(String name) {
        this._name = name;
        this._futuresList = new ArrayList<ServerResponseFuture<T>>();
        this._delayedResponse = null;
        this._error = null;
    }

    public void start(Collection<ServerResponseFuture<T>> futuresList) {
        boolean started = super.start();
        if (!started) {
            String msg = "Unable to start the future. State is already : " + (Object)((Object)this._state);
            LOGGER.error(msg);
            throw new IllegalStateException(msg);
        }
        this._futuresList.addAll(futuresList);
        this._latch = new CountDownLatch(futuresList.size());
        for (ServerResponseFuture<T> entry : this._futuresList) {
            if (null == entry) continue;
            this.addResponseFutureListener(entry);
        }
    }

    @Override
    protected void cancelUnderlyingFutures() {
        for (ServerResponseFuture<T> entry : this._futuresList) {
            entry.cancel(true);
        }
    }

    @Override
    public Map<ServerInstance, T> get() throws InterruptedException, ExecutionException {
        this._latch.await();
        return this._delayedResponse;
    }

    @Override
    public Map<ServerInstance, Throwable> getError() {
        return this._error;
    }

    @Override
    public Map<ServerInstance, T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this._latch.await(timeout, unit);
        return this._delayedResponse;
    }

    @Override
    public T getOne() throws InterruptedException, ExecutionException {
        this._latch.await();
        if (null == this._delayedResponse || this._delayedResponse.isEmpty()) {
            return null;
        }
        return this._delayedResponse.values().iterator().next();
    }

    @Override
    public T getOne(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean notElapsed = this._latch.await(timeout, unit);
        if (!notElapsed) {
            throw new TimeoutException("Timedout waiting for async result for selecting future " + this._name);
        }
        if (null == this._delayedResponse || this._delayedResponse.isEmpty()) {
            return null;
        }
        return this._delayedResponse.values().iterator().next();
    }

    @Override
    public long getDurationMillis() {
        return this._durationMillis;
    }

    @Override
    protected boolean processFutureResult(ServerInstance server, Map<ServerInstance, T> response, Map<ServerInstance, Throwable> error, long durationMillis) {
        boolean done = false;
        if (null != response) {
            LOGGER.debug("Error got from {} is : {}", (Object)server, response);
            this._delayedResponse = response;
            this._error = null;
            done = true;
        } else if (null != error) {
            LOGGER.debug("Error got from {} is : {}", (Object)server, error);
            this._error = error;
        }
        this._durationMillis = durationMillis;
        return done;
    }

    @Override
    public ServerInstance getServerInstance() {
        throw new RuntimeException("Invalid API call on selecting future");
    }

    @Override
    public String getName() {
        return this._name;
    }
}

