/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.conf;

import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.transport.config.ConnectionPoolConfig;
import org.apache.pinot.$internal.org.apache.pinot.transport.config.RoutingTableConfig;

public class TransportClientConf {
    public static final String ROUTING_MODE_KEY = "routingMode";
    public static final String CFG_BASED_ROUTING = "routing";
    public static final String HELIX_CONFIG = "helix";
    public static final String CONNECTION_POOL_CONFIG = "connPool";
    private static final String DEFAULT_ROUTING_MODE = "CONFIG";
    private RoutingMode _routingMode = RoutingMode.valueOf("CONFIG");
    private RoutingTableConfig _cfgBasedRouting = new RoutingTableConfig();
    private ConnectionPoolConfig _connPool = new ConnectionPoolConfig();

    public void init(Configuration cfg) {
        Configuration connPoolCfg;
        if (cfg.containsKey(ROUTING_MODE_KEY)) {
            this._routingMode = RoutingMode.valueOf(cfg.getString(ROUTING_MODE_KEY));
        }
        if (this._routingMode == RoutingMode.CONFIG) {
            this._cfgBasedRouting.init(cfg.subset(CFG_BASED_ROUTING));
        }
        if ((connPoolCfg = cfg.subset(CONNECTION_POOL_CONFIG)) != null) {
            this._connPool.init(connPoolCfg);
        }
    }

    public RoutingMode getRoutingMode() {
        return this._routingMode;
    }

    public RoutingTableConfig getCfgBasedRouting() {
        return this._cfgBasedRouting;
    }

    public ConnectionPoolConfig getConnPool() {
        return this._connPool;
    }

    public static enum RoutingMode {
        CONFIG,
        HELIX;

    }
}

