/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.config;

import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.transport.config.ThreadPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolConfig {
    public static final String THREAD_POOL_KEY = "threadPool";
    public static final String MIN_CONNECTIONS_PER_SERVER_KEY = "minConnectionsPerServer";
    public static final String MAX_CONNECTIONS_PER_SERVER_KEY = "maxConnectionsPerServer";
    public static final String MAX_BACKLOG_PER_SERVER_KEY = "maxBacklogPerServer";
    public static final String IDLE_TIMEOUT_MS_KEY = "idleTimeoutMs";
    private final int DEFAULT_MIN_CONNECTIONS_PER_SERVER = 10;
    private final int DEFAULT_MAX_CONNECTIONS_PER_SERVER = 30;
    private final int DEFAULT_MAX_BACKLOG_PER_SERVER = 30;
    private static final long DEFAULT_IDLE_TIMEOUT_MS = 21600000L;
    private ThreadPoolConfig _threadPool = new ThreadPoolConfig();
    private int _minConnectionsPerServer = 10;
    private int _maxConnectionsPerServer = 30;
    private int _maxBacklogPerServer = 30;
    private long _idleTimeoutMs = 21600000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPoolConfig.class);

    public void init(Configuration cfg) {
        if (cfg.containsKey(THREAD_POOL_KEY)) {
            this._threadPool.init(cfg.subset(THREAD_POOL_KEY));
        }
        if (cfg.containsKey(IDLE_TIMEOUT_MS_KEY)) {
            this._idleTimeoutMs = cfg.getLong(IDLE_TIMEOUT_MS_KEY);
        }
        if (cfg.containsKey(MIN_CONNECTIONS_PER_SERVER_KEY)) {
            this._minConnectionsPerServer = cfg.getInt(MIN_CONNECTIONS_PER_SERVER_KEY);
        }
        if (cfg.containsKey(MAX_CONNECTIONS_PER_SERVER_KEY)) {
            this._maxConnectionsPerServer = cfg.getInt(MAX_CONNECTIONS_PER_SERVER_KEY);
        }
        if (cfg.containsKey(MAX_BACKLOG_PER_SERVER_KEY)) {
            this._maxBacklogPerServer = cfg.getInt(MAX_BACKLOG_PER_SERVER_KEY);
        }
        if (this._minConnectionsPerServer > this._maxConnectionsPerServer || this._maxConnectionsPerServer <= 0 || this._minConnectionsPerServer < 1) {
            LOGGER.warn("Invalid values for minConnectionsPerServer({}) and maxConnectionsPerServer({}). Resetting to defaults:", (Object)this._minConnectionsPerServer, (Object)this._maxConnectionsPerServer);
            this._minConnectionsPerServer = 10;
            this._maxConnectionsPerServer = 30;
        }
        if (this._idleTimeoutMs < 0L) {
            LOGGER.warn("Invalid value for idleTimeoutMs({}). Resetting to default.");
            this._idleTimeoutMs = 21600000L;
        }
        if (this._maxBacklogPerServer < 0) {
            LOGGER.warn("Invalid value for maxBacklogPerServer({}). Resetting to default.");
            this._maxBacklogPerServer = 30;
        }
        LOGGER.info(this.toString());
    }

    public String toString() {
        return "threadPool = " + this._threadPool + ", idleTimeoutMs = " + this._idleTimeoutMs + ", minConnectionsPerServer = " + this._minConnectionsPerServer + ", maxConnectionsPerServer = " + this._maxConnectionsPerServer + ", maxBacklogPerServer = " + this._maxBacklogPerServer;
    }

    public ThreadPoolConfig getThreadPool() {
        return this._threadPool;
    }

    public int getMinConnectionsPerServer() {
        return this._minConnectionsPerServer;
    }

    public int getMaxConnectionsPerServer() {
        return this._maxConnectionsPerServer;
    }

    public int getMaxBacklogPerServer() {
        return this._maxBacklogPerServer;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }
}

