/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.$internal.org.apache.pinot.transport.config.PerTableRoutingConfig;

public class RoutingTableConfig {
    private Configuration _brokerRoutingConfig;
    private Map<String, PerTableRoutingConfig> _tableRoutingCfg = new HashMap<String, PerTableRoutingConfig>();
    private static final String TABLE_NAME = "tableName";

    public void init(Configuration brokerRoutingConfig) {
        this._brokerRoutingConfig = brokerRoutingConfig;
        this.loadConfigs();
    }

    private void loadConfigs() {
        List<String> tables = this.getTableNames();
        for (String s : tables) {
            PerTableRoutingConfig cfg = new PerTableRoutingConfig(this._brokerRoutingConfig.subset(s));
            this._tableRoutingCfg.put(s, cfg);
        }
    }

    private List<String> getTableNames() {
        return this._brokerRoutingConfig.getList(TABLE_NAME);
    }

    public Map<String, PerTableRoutingConfig> getPerTableRoutingCfg() {
        return this._tableRoutingCfg;
    }

    public String toString() {
        return "BrokerRoutingConfig [_brokerRoutingConfig=" + this._brokerRoutingConfig + ", _perTableRoutingCfg=" + this._tableRoutingCfg + "]";
    }
}

