/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.config;

import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;

public class ThreadPoolConfig {
    public static final String CORE_POOL_SIZE_KEY = "corePoolSize";
    public static final String MAX_POOL_SIZE_KEY = "maxPoolSize";
    public static final String IDLE_TIMEOUT_MS_KEY = "idleTimeoutMs";
    private static final int DEFAULT_CORE_POOL_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final long DEFAULT_IDLE_TIMEOUT_MS = 43200000L;
    private int _corePoolSize = 10;
    private int _maxPoolSize = 10;
    private long _idleTimeoutMs = 43200000L;

    public void init(Configuration cfg) {
        if (cfg.containsKey(CORE_POOL_SIZE_KEY)) {
            this._corePoolSize = cfg.getInt(CORE_POOL_SIZE_KEY);
        }
        if (cfg.containsKey(MAX_POOL_SIZE_KEY)) {
            this._maxPoolSize = cfg.getInt(MAX_POOL_SIZE_KEY);
        }
        if (cfg.containsKey(IDLE_TIMEOUT_MS_KEY)) {
            this._idleTimeoutMs = cfg.getLong(IDLE_TIMEOUT_MS_KEY);
        }
    }

    public int getCorePoolSize() {
        return this._corePoolSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }
}

