/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.metrics;

import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.Sampling;
import org.apache.pinot.$internal.com.yammer.metrics.core.Summarizable;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyServerMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.TransportServerMetrics;
import org.apache.pinot.common.metrics.AggregatedCounter;
import org.apache.pinot.common.metrics.AggregatedHistogram;
import org.apache.pinot.common.metrics.AggregatedMetricsRegistry;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;

public class AggregatedTransportServerMetrics
implements TransportServerMetrics {
    public static final String REQUESTS_RECEIVED = "Requests-Sent";
    public static final String BYTES_SENT = "bytes-Sent";
    public static final String BYTES_RECEIVED = "bytes-received";
    public static final String SEND_RESPONSE_MS = "Send-Response-MS";
    public static final String PROCESSING_LATENCY_MS = "Processing-Latency-MS";
    public static final String ERRORS = "errors";
    private final AggregatedCounter _requestsReceived;
    private final AggregatedCounter _bytesSent;
    private final AggregatedCounter _bytesReceived;
    private final AggregatedCounter _errors;
    private final AggregatedHistogram<Sampling> _sendResponseMsHistogram;
    private final AggregatedHistogram<Sampling> _processingLatencyMsHistogram;

    public AggregatedTransportServerMetrics(AggregatedMetricsRegistry registry, String group) {
        this._requestsReceived = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", REQUESTS_RECEIVED));
        this._bytesSent = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", BYTES_SENT));
        this._bytesReceived = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", BYTES_RECEIVED));
        this._errors = MetricsHelper.newAggregatedCounter(registry, new MetricName(group, "", ERRORS));
        this._sendResponseMsHistogram = MetricsHelper.newAggregatedHistogram(registry, new MetricName(group, "", SEND_RESPONSE_MS));
        this._processingLatencyMsHistogram = MetricsHelper.newAggregatedHistogram(registry, new MetricName(group, "", PROCESSING_LATENCY_MS));
    }

    public void addTransportClientMetrics(NettyServerMetrics metric) {
        this._requestsReceived.add(metric.getRequestsReceived());
        this._bytesSent.add(metric.getBytesSent());
        this._bytesReceived.add(metric.getBytesReceived());
        this._errors.add(metric.getErrors());
        this._sendResponseMsHistogram.add(metric.getSendResponseMsHistogram());
        this._processingLatencyMsHistogram.add(metric.getProcessingLatencyMsHistogram());
    }

    public void addTransportClientMetrics(AggregatedTransportServerMetrics metric) {
        this._requestsReceived.add(metric.getRequestsReceived());
        this._bytesSent.add(metric.getBytesSent());
        this._bytesReceived.add(metric.getBytesReceived());
        this._errors.add(metric.getErrors());
        this._sendResponseMsHistogram.add(metric.getSendResponseMsHistogram());
        this._processingLatencyMsHistogram.add(metric.getProcessingLatencyMsHistogram());
    }

    public void removeTransportClientMetrics(NettyServerMetrics metric) {
        this._requestsReceived.remove(metric.getRequestsReceived());
        this._bytesSent.remove(metric.getBytesSent());
        this._bytesReceived.remove(metric.getBytesReceived());
        this._errors.remove(metric.getErrors());
        this._sendResponseMsHistogram.remove(metric.getSendResponseMsHistogram());
        this._processingLatencyMsHistogram.remove(metric.getProcessingLatencyMsHistogram());
    }

    public void removeTransportClientMetrics(AggregatedTransportServerMetrics metric) {
        this._requestsReceived.remove(metric.getRequestsReceived());
        this._bytesSent.remove(metric.getBytesSent());
        this._bytesReceived.remove(metric.getBytesReceived());
        this._errors.remove(metric.getErrors());
        this._sendResponseMsHistogram.remove(metric.getSendResponseMsHistogram());
        this._processingLatencyMsHistogram.remove(metric.getProcessingLatencyMsHistogram());
    }

    @Override
    public long getTotalRequests() {
        return this._requestsReceived.count();
    }

    @Override
    public long getTotalBytesSent() {
        return this._bytesSent.count();
    }

    @Override
    public long getTotalBytesReceived() {
        return this._bytesReceived.count();
    }

    @Override
    public long getTotalErrors() {
        return this._errors.count();
    }

    @Override
    public <T extends Sampling & Summarizable> LatencyMetric<T> getSendResponseLatencyMs() {
        return new LatencyMetric<AggregatedHistogram<Sampling>>(this._sendResponseMsHistogram);
    }

    @Override
    public <T extends Sampling & Summarizable> LatencyMetric<T> getProcessingLatencyMs() {
        return new LatencyMetric<AggregatedHistogram<Sampling>>(this._processingLatencyMsHistogram);
    }

    private AggregatedCounter getRequestsReceived() {
        return this._requestsReceived;
    }

    private AggregatedCounter getBytesSent() {
        return this._bytesSent;
    }

    private AggregatedCounter getBytesReceived() {
        return this._bytesReceived;
    }

    private AggregatedCounter getErrors() {
        return this._errors;
    }

    private AggregatedHistogram<Sampling> getSendResponseMsHistogram() {
        return this._sendResponseMsHistogram;
    }

    private AggregatedHistogram<Sampling> getProcessingLatencyMsHistogram() {
        return this._processingLatencyMsHistogram;
    }
}

