/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.metrics;

import org.apache.pinot.$internal.com.yammer.metrics.core.Counter;
import org.apache.pinot.$internal.com.yammer.metrics.core.Gauge;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.TransportClientMetrics;
import org.apache.pinot.common.metrics.LatencyMetric;
import org.apache.pinot.common.metrics.MetricsHelper;

public class NettyClientMetrics
implements TransportClientMetrics {
    public static final String CONNECT_TIME = "CONNECT-MS";
    public static final String REQUESTS_SENT = "Requests-Sent";
    public static final String BYTES_SENT = "bytes-Sent";
    public static final String BYTES_RECEIVED = "bytes-received";
    public static final String ERRORS = "errors";
    public static final String SEND_REQUEST_MS = "Send-Request-MS";
    public static final String RESPONSE_LATENCY_MS = "Latency-MS";
    private final Counter _requestsSent;
    private final Counter _bytesSent;
    private final Counter _bytesReceived;
    private final Counter _errors;
    private final Histogram _sendRequestMsHistogram;
    private final Histogram _responseLatencyMsHistogram;
    private final Gauge<Long> _connectMsGauge;
    private long _connectMs;

    public NettyClientMetrics(MetricsRegistry registry, String group) {
        this._requestsSent = MetricsHelper.newCounter(registry, new MetricName(group, "", REQUESTS_SENT));
        this._bytesSent = MetricsHelper.newCounter(registry, new MetricName(group, "", BYTES_SENT));
        this._bytesReceived = MetricsHelper.newCounter(registry, new MetricName(group, "", BYTES_RECEIVED));
        this._errors = MetricsHelper.newCounter(registry, new MetricName(group, "", ERRORS));
        this._sendRequestMsHistogram = MetricsHelper.newHistogram(registry, new MetricName(group, "", SEND_REQUEST_MS), false);
        this._responseLatencyMsHistogram = MetricsHelper.newHistogram(registry, new MetricName(group, "", RESPONSE_LATENCY_MS), false);
        this._connectMsGauge = MetricsHelper.newGauge(registry, new MetricName(group, "", CONNECT_TIME), new ConnectMsGauge());
    }

    public void addRequestResponseStats(long bytesSent, long numRequests, long bytesReceived, boolean isError, long sendRequestMs, long responseLatencyMs) {
        this._requestsSent.inc(numRequests);
        this._bytesSent.inc(bytesSent);
        this._bytesReceived.inc(bytesReceived);
        if (isError) {
            this._errors.inc();
        }
        this._sendRequestMsHistogram.update(sendRequestMs);
        this._responseLatencyMsHistogram.update(responseLatencyMs);
    }

    public void addConnectStats(long connectMs) {
        this._connectMs = connectMs;
    }

    public Counter getRequestsSent() {
        return this._requestsSent;
    }

    public Counter getBytesSent() {
        return this._bytesSent;
    }

    public Counter getBytesReceived() {
        return this._bytesReceived;
    }

    public Counter getErrors() {
        return this._errors;
    }

    public Histogram getSendRequestMsHistogram() {
        return this._sendRequestMsHistogram;
    }

    public Histogram getResponseLatencyMsHistogram() {
        return this._responseLatencyMsHistogram;
    }

    public String toString() {
        return "NettyClientMetric [_requestsSent=" + this._requestsSent.count() + ", _bytesSent=" + this._bytesSent.count() + ", _bytesReceived=" + this._bytesReceived.count() + ", _errors=" + this._errors.count() + ", _sendRequestMsGauge=" + this._sendRequestMsHistogram.count() + ", _responseLatencyMsGauge=" + this._responseLatencyMsHistogram.count() + ", _connectMsGauge=" + this._connectMsGauge.value() + "]";
    }

    @Override
    public long getTotalRequests() {
        return this._requestsSent.count();
    }

    @Override
    public long getTotalBytesSent() {
        return this._bytesSent.count();
    }

    @Override
    public long getTotalBytesReceived() {
        return this._bytesReceived.count();
    }

    @Override
    public long getTotalErrors() {
        return this._errors.count();
    }

    public LatencyMetric<Histogram> getSendRequestLatencyMs() {
        return new LatencyMetric<Histogram>(this._sendRequestMsHistogram);
    }

    public LatencyMetric<Histogram> getResponseLatencyMs() {
        return new LatencyMetric<Histogram>(this._responseLatencyMsHistogram);
    }

    @Override
    public long getConnectTimeMs() {
        return this._connectMs;
    }

    public Gauge<Long> getConnectMsGauge() {
        return this._connectMsGauge;
    }

    private class ConnectMsGauge
    extends Gauge<Long> {
        private ConnectMsGauge() {
        }

        @Override
        public Long value() {
            return NettyClientMetrics.this._connectMs;
        }
    }
}

