/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.netty;

import org.apache.pinot.$internal.io.netty.bootstrap.Bootstrap;
import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.channel.Channel;
import org.apache.pinot.$internal.io.netty.channel.EventLoopGroup;
import org.apache.pinot.$internal.io.netty.util.Timer;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.AsyncResponseFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.NoneType;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.NettyTCPClientConnection;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyClientConnection {
    protected static Logger LOGGER = LoggerFactory.getLogger(NettyTCPClientConnection.class);
    protected final ServerInstance _server;
    protected final EventLoopGroup _eventGroup;
    protected Bootstrap _bootstrap;
    protected volatile Channel _channel;
    protected volatile State _connState = State.INIT;
    protected final long _connId;
    protected final Timer _timer;
    protected volatile Callback<NoneType> _requestCallback;

    public NettyClientConnection(ServerInstance server, EventLoopGroup eventGroup, Timer timer, long connId) {
        this._server = server;
        this._connId = connId;
        this._timer = timer;
        this._eventGroup = eventGroup;
    }

    public long getConnId() {
        return this._connId;
    }

    public abstract boolean connect();

    public abstract void close() throws InterruptedException;

    public abstract ResponseFuture sendRequest(ByteBuf var1, long var2, long var4);

    public void setRequestCallback(Callback<NoneType> callback) {
        this._requestCallback = callback;
    }

    public boolean validate() {
        if (null == this._channel) {
            return false;
        }
        return this._channel.isActive();
    }

    public ServerInstance getServer() {
        return this._server;
    }

    public static class ResponseFuture
    extends AsyncResponseFuture<byte[]> {
        public ResponseFuture(ServerInstance key, String ctxt) {
            super(key, ctxt);
        }

        public ResponseFuture(ServerInstance key, Throwable error, String ctxt) {
            super(key, error, ctxt);
        }
    }

    public static enum State {
        INIT,
        CONNECTED,
        REQUEST_WRITTEN,
        REQUEST_SENT,
        ERROR,
        GOT_RESPONSE;


        public boolean isValidTransition(State nextState) {
            switch (nextState) {
                case INIT: {
                    return false;
                }
                case CONNECTED: {
                    return this == INIT;
                }
                case REQUEST_WRITTEN: {
                    return this == CONNECTED || this == GOT_RESPONSE;
                }
                case REQUEST_SENT: {
                    return this == REQUEST_WRITTEN;
                }
                case ERROR: {
                    return true;
                }
                case GOT_RESPONSE: {
                    return this == REQUEST_SENT;
                }
            }
            return false;
        }
    }
}

