/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.netty;

import java.net.ConnectException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.$internal.io.netty.bootstrap.Bootstrap;
import org.apache.pinot.$internal.io.netty.buffer.ByteBuf;
import org.apache.pinot.$internal.io.netty.channel.Channel;
import org.apache.pinot.$internal.io.netty.channel.ChannelFuture;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandler;
import org.apache.pinot.$internal.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.$internal.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pinot.$internal.io.netty.channel.ChannelInitializer;
import org.apache.pinot.$internal.io.netty.channel.ChannelPipeline;
import org.apache.pinot.$internal.io.netty.channel.EventLoopGroup;
import org.apache.pinot.$internal.io.netty.channel.socket.SocketChannel;
import org.apache.pinot.$internal.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pinot.$internal.io.netty.handler.codec.LengthFieldPrepender;
import org.apache.pinot.$internal.io.netty.util.Timeout;
import org.apache.pinot.$internal.io.netty.util.Timer;
import org.apache.pinot.$internal.io.netty.util.TimerTask;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.NettyClientMetrics;
import org.apache.pinot.$internal.org.apache.pinot.transport.netty.NettyClientConnection;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.apache.pinot.common.response.ServerInstance;

public class NettyTCPClientConnection
extends NettyClientConnection {
    private NettyClientConnectionHandler _handler = null;
    private NettyClientMetrics _clientMetric = null;
    private final AtomicReference<NettyClientConnection.ResponseFuture> _outstandingFuture;
    private long _lastRequsetSizeInBytes;
    private long _lastResponseSizeInBytes;
    private MetricsHelper.TimerContext _lastSendRequestLatency;
    private MetricsHelper.TimerContext _lastResponseLatency;
    private volatile Timeout _lastRequestTimeout;
    private volatile long _lastRequestTimeoutMS;
    private volatile long _lastRequestId;
    private volatile Throwable _lastError;
    private volatile boolean _selfClose = false;
    private static final AtomicLong _connIdGen = new AtomicLong(0L);
    private final CountDownLatch _channelSet = new CountDownLatch(1);

    public NettyTCPClientConnection(ServerInstance server, EventLoopGroup eventGroup, Timer timer, NettyClientMetrics metric) {
        super(server, eventGroup, timer, _connIdGen.incrementAndGet());
        this._handler = new NettyClientConnectionHandler();
        this._outstandingFuture = new AtomicReference();
        this._clientMetric = metric;
        this.init();
    }

    private void init() {
        this._bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this._bootstrap.group(this._eventGroup)).channel(NioSocketChannel.class)).handler(new ChannelHandlerInitializer(this._handler));
    }

    protected void setSelfClose(boolean selfClose) {
        this._selfClose = selfClose;
    }

    protected boolean isSelfClose() {
        return this._selfClose;
    }

    private void checkTransition(NettyClientConnection.State nextState) {
        if (!this._connState.isValidTransition(nextState)) {
            throw new IllegalStateException("Wrong transition :" + (Object)((Object)this._connState) + " -> " + (Object)((Object)nextState) + ", connId:" + this.getConnId());
        }
    }

    @Override
    public boolean connect() {
        try {
            this.checkTransition(NettyClientConnection.State.CONNECTED);
            MetricsHelper.TimerContext t = MetricsHelper.startTimer();
            ChannelFuture f = this._bootstrap.connect(this._server.getHostname(), this._server.getPort()).sync();
            f.get();
            this._channelSet.await();
            t.stop();
            this._connState = NettyClientConnection.State.CONNECTED;
            this._clientMetric.addConnectStats(t.getLatencyMs());
            return true;
        }
        catch (Exception ie) {
            if (ie instanceof ConnectException && ie.getMessage() != null && ie.getMessage().startsWith("Connection refused")) {
                LOGGER.info("Could not connect to server {}:{} connId:{}", new Object[]{this._server, ie.getMessage(), this.getConnId()});
            } else {
                LOGGER.error("Got exception when connecting to server {} connId {}", new Object[]{this._server, ie, this.getConnId()});
            }
            return false;
        }
    }

    private void setChannel(Channel channel) {
        this._channel = channel;
        this._channelSet.countDown();
        LOGGER.info("Setting channel for connection id ({}) to server {}. Is channel null? {}", new Object[]{this._connId, this._server, null == this._channel});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NettyClientConnection.ResponseFuture sendRequest(ByteBuf serializedRequest, long requestId, long timeoutMS) {
        this.checkTransition(NettyClientConnection.State.REQUEST_WRITTEN);
        this._lastRequsetSizeInBytes = serializedRequest.readableBytes();
        this._lastSendRequestLatency = MetricsHelper.startTimer();
        this._lastResponseLatency = MetricsHelper.startTimer();
        this._outstandingFuture.set(new NettyClientConnection.ResponseFuture(this._server, "Server response future for reqId " + requestId + " to server " + this._server + " connId " + this.getConnId()));
        this._lastRequestTimeoutMS = timeoutMS;
        this._lastRequestId = requestId;
        this._lastError = null;
        this._lastRequestTimeout = this._timer.newTimeout(new ReadTimeoutHandler(), this._lastRequestTimeoutMS, TimeUnit.MILLISECONDS);
        try {
            this._connState = NettyClientConnection.State.REQUEST_WRITTEN;
            this._channel.writeAndFlush(serializedRequest);
            NettyClientConnectionHandler nettyClientConnectionHandler = this._handler;
            synchronized (nettyClientConnectionHandler) {
                this._lastSendRequestLatency.stop();
                if (this._connState == NettyClientConnection.State.REQUEST_WRITTEN) {
                    this._connState = NettyClientConnection.State.REQUEST_SENT;
                } else {
                    LOGGER.info("Response/Error already arrived !! Checking-in/destroying the connection to server {}, connId {}", (Object)this._server, (Object)this.getConnId());
                    if (this._connState == NettyClientConnection.State.GOT_RESPONSE) {
                        if (null != this._requestCallback) {
                            this._requestCallback.onSuccess(null);
                        }
                    } else if (this._connState == NettyClientConnection.State.ERROR) {
                        if (null != this._requestCallback) {
                            this._requestCallback.onError(this._lastError);
                        }
                    } else {
                        throw new IllegalStateException("Invalid connection State (" + (Object)((Object)this._connState) + ") when sending request to  server " + this._server + ", connId " + this.getConnId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Got exception sending the request to server ({}) id {}", new Object[]{this._server, this.getConnId(), e});
            this._outstandingFuture.get().onError(e);
            if (null != this._requestCallback) {
                this._requestCallback.onError(e);
            }
            this._lastSendRequestLatency.stop();
        }
        return this._outstandingFuture.get();
    }

    protected void cancelLastRequestTimeout() {
        if (null != this._lastRequestTimeout) {
            this._lastRequestTimeout.cancel();
            this._lastRequestTimeout = null;
        }
    }

    public String toString() {
        return "Server:" + this._server + ",State:" + (Object)((Object)this._connState) + ",connId:" + this.getConnId();
    }

    protected void releaseResources() {
    }

    @Override
    public void close() throws InterruptedException {
        LOGGER.info("Closing client channel to {} connId {}", (Object)this._server, (Object)this.getConnId());
        if (null != this._channel) {
            this._channel.close().sync();
            this.setSelfClose(true);
        }
    }

    public class ReadTimeoutHandler
    implements TimerTask {
        @Override
        public void run(Timeout timeout) throws Exception {
            String message = "Request (" + NettyTCPClientConnection.this._lastRequestId + ") to server " + NettyTCPClientConnection.this._server + " connId " + NettyTCPClientConnection.this.getConnId() + " timed-out waiting for response. Closing the channel !!";
            NettyClientConnection.LOGGER.warn(message);
            Exception e = new Exception(message);
            ((NettyClientConnection.ResponseFuture)NettyTCPClientConnection.this._outstandingFuture.get()).onError(e);
            NettyTCPClientConnection.this.close();
        }
    }

    public class ChannelHandlerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final ChannelHandler _handler;

        public ChannelHandlerInitializer(ChannelHandler handler) {
            this._handler = handler;
        }

        @Override
        protected void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
            pipeline.addLast("encoder", (ChannelHandler)new LengthFieldPrepender(4));
            pipeline.addLast("handler", this._handler);
            NettyClientConnection.LOGGER.info("Server Channel pipeline setup. Pipeline:" + ch.pipeline().names());
        }
    }

    public class NettyClientConnectionHandler
    extends ChannelInboundHandlerAdapter {
        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            NettyClientConnection.LOGGER.info("Client Channel to server ({}) (id = {}) in inactive state (closed).  !!", (Object)NettyTCPClientConnection.this._server, (Object)NettyTCPClientConnection.this._connId);
            Exception ex = new Exception("Client Channel to server (" + NettyTCPClientConnection.this._server + ") is in inactive state (closed) !!");
            this.closeOnError(ctx, ex);
            NettyTCPClientConnection.this.releaseResources();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyClientConnection.LOGGER.info("Client Channel to server ({}) (id = {}) is active.", (Object)NettyTCPClientConnection.this._server, (Object)NettyTCPClientConnection.this._connId);
            NettyTCPClientConnection.this.setChannel(ctx.channel());
            super.channelActive(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void channelRead(ChannelHandlerContext ctx, Object msg) {
            ByteBuf responseByteBuf = (ByteBuf)msg;
            try {
                NettyTCPClientConnection.this.cancelLastRequestTimeout();
                NettyTCPClientConnection.this._lastResponseLatency.stop();
                int numReadableBytes = responseByteBuf.readableBytes();
                byte[] responseBytes = new byte[numReadableBytes];
                if (numReadableBytes > 0) {
                    responseByteBuf.readBytes(responseBytes);
                }
                NettyTCPClientConnection.this._lastResponseSizeInBytes = numReadableBytes;
                NettyClientConnection.State prevState = NettyTCPClientConnection.this._connState;
                NettyTCPClientConnection.this._connState = NettyClientConnection.State.GOT_RESPONSE;
                ((NettyClientConnection.ResponseFuture)NettyTCPClientConnection.this._outstandingFuture.get()).onSuccess(responseBytes);
                NettyTCPClientConnection.this._clientMetric.addRequestResponseStats(NettyTCPClientConnection.this._lastRequsetSizeInBytes, 1L, NettyTCPClientConnection.this._lastResponseSizeInBytes, false, NettyTCPClientConnection.this._lastSendRequestLatency.getLatencyMs(), NettyTCPClientConnection.this._lastResponseLatency.getLatencyMs());
                if (null != NettyTCPClientConnection.this._requestCallback && prevState == NettyClientConnection.State.REQUEST_SENT) {
                    NettyTCPClientConnection.this._requestCallback.onSuccess(null);
                }
            }
            finally {
                responseByteBuf.release();
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            NettyClientConnection.LOGGER.info("Got exception in the channel to {}, connId {}, cause:{}", new Object[]{NettyTCPClientConnection.this._server, NettyTCPClientConnection.this.getConnId(), cause.getMessage()});
            this.closeOnError(ctx, cause);
            NettyTCPClientConnection.this.releaseResources();
        }

        private synchronized void closeOnError(ChannelHandlerContext ctx, Throwable cause) {
            if (NettyTCPClientConnection.this._connState != NettyClientConnection.State.ERROR) {
                NettyTCPClientConnection.this.cancelLastRequestTimeout();
                if (null != NettyTCPClientConnection.this._lastResponseLatency) {
                    NettyTCPClientConnection.this._lastResponseLatency.stop();
                }
                NettyTCPClientConnection.this.checkTransition(NettyClientConnection.State.ERROR);
                if (null != NettyTCPClientConnection.this._outstandingFuture.get()) {
                    ((NettyClientConnection.ResponseFuture)NettyTCPClientConnection.this._outstandingFuture.get()).onError(cause);
                }
                NettyTCPClientConnection.this._clientMetric.addRequestResponseStats(NettyTCPClientConnection.this._lastRequsetSizeInBytes, 1L, NettyTCPClientConnection.this._lastResponseSizeInBytes, true, null == NettyTCPClientConnection.this._lastSendRequestLatency ? 0L : NettyTCPClientConnection.this._lastSendRequestLatency.getLatencyMs(), null == NettyTCPClientConnection.this._lastSendRequestLatency ? 0L : NettyTCPClientConnection.this._lastResponseLatency.getLatencyMs());
                if (null != NettyTCPClientConnection.this._requestCallback && NettyTCPClientConnection.this._connState == NettyClientConnection.State.REQUEST_SENT) {
                    NettyClientConnection.LOGGER.info("Discarding the connection to {} connId {}", (Object)NettyTCPClientConnection.this._server, (Object)NettyTCPClientConnection.this.getConnId());
                    NettyTCPClientConnection.this._requestCallback.onError(cause);
                }
                NettyTCPClientConnection.this._connState = NettyClientConnection.State.ERROR;
                ctx.close();
            }
        }
    }
}

