/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.apache.pinot.transport.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.yammer.metrics.core.Histogram;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.AsyncResponseFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.Callback;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.CompositeFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.common.ServerResponseFuture;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.AggregatedPoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.metrics.PoolStats;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.AsyncPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.AsyncPoolImpl;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.AsyncPoolResourceManagerAdapter;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.KeyedPool;
import org.apache.pinot.$internal.org.apache.pinot.transport.pool.PooledResourceManager;
import org.apache.pinot.common.response.ServerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedPoolImpl<T>
implements KeyedPool<T> {
    protected static Logger LOGGER = LoggerFactory.getLogger(KeyedPoolImpl.class);
    private State _state;
    private final int _maxResourcesPerKey;
    private final int _minResourcesPerKey;
    private final long _idleTimeoutMs;
    private final int _maxPendingCheckoutRequests;
    private final ScheduledExecutorService _timeoutExecutor;
    private final PooledResourceManager<T> _resourceManager;
    private final ExecutorService _executorService;
    private CompositeFuture<.NoneType> _shutdownFuture;
    private final MetricsRegistry _metricRegistry;
    private final AggregatedPoolStats<Histogram> _poolStats;
    private final ConcurrentMap<ServerInstance, AsyncPool<T>> _keyedPool;
    private final ConcurrentMap<ServerInstance, AsyncPoolResourceManagerAdapter<T>> _pooledResourceManagerMap;
    private final Object _mutex = new Object();

    public KeyedPoolImpl(int minResourcesPerKey, int maxResourcesPerKey, long idleTimeoutMs, int maxPendingCheckoutRequests, PooledResourceManager<T> resourceManager, ScheduledExecutorService timeoutExecutorService, ExecutorService executorService, MetricsRegistry registry) {
        this._keyedPool = new ConcurrentHashMap<ServerInstance, AsyncPool<T>>();
        this._pooledResourceManagerMap = new ConcurrentHashMap<ServerInstance, AsyncPoolResourceManagerAdapter<T>>();
        this._minResourcesPerKey = minResourcesPerKey;
        this._maxResourcesPerKey = maxResourcesPerKey;
        this._idleTimeoutMs = idleTimeoutMs;
        this._maxPendingCheckoutRequests = maxPendingCheckoutRequests;
        this._timeoutExecutor = timeoutExecutorService;
        this._executorService = executorService;
        this._resourceManager = resourceManager;
        this._state = State.INIT;
        this._metricRegistry = registry;
        this._poolStats = new AggregatedPoolStats();
    }

    @Override
    public void start() {
        this._state = State.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerResponseFuture<T> checkoutObject(ServerInstance key, String context) {
        AsyncPoolImpl pool = (AsyncPoolImpl)this._keyedPool.get(key);
        if (null == pool) {
            Object object = this._mutex;
            synchronized (object) {
                pool = (AsyncPool)this._keyedPool.get(key);
                if (null == pool) {
                    String poolName = "Pool for (" + key + ")";
                    AsyncPoolResourceManagerAdapter<T> rmAdapter = new AsyncPoolResourceManagerAdapter<T>(key, this._resourceManager, this._executorService, this._metricRegistry);
                    pool = new AsyncPoolImpl(poolName, rmAdapter, this._maxResourcesPerKey, this._idleTimeoutMs, this._timeoutExecutor, this._executorService, this._maxPendingCheckoutRequests, AsyncPoolImpl.Strategy.LRU, this._minResourcesPerKey, this._metricRegistry);
                    this._keyedPool.put(key, pool);
                    this._poolStats.add(pool);
                    this._pooledResourceManagerMap.put(key, rmAdapter);
                    pool.start();
                }
            }
        }
        AsyncResponseFuture future = new AsyncResponseFuture(key, "ConnPool checkout future for key " + key + "(" + context + ")");
        .Cancellable cancellable = pool.get(future);
        future.setCancellable(cancellable);
        return future;
    }

    @Override
    public void checkinObject(ServerInstance key, T object) {
        AsyncPool pool = (AsyncPool)this._keyedPool.get(key);
        if (null == pool) {
            throw new IllegalStateException("Trying to checkin an object from a pool which does not exist. No pool available for key (" + key + ") !!");
        }
        pool.put(object);
    }

    @Override
    public void destroyObject(ServerInstance key, T object) {
        AsyncPool pool = (AsyncPool)this._keyedPool.get(key);
        LOGGER.info("Destroying object for the key (" + key + ") object :" + object);
        if (null == pool) {
            throw new IllegalStateException("Trying to destroy an object from a pool which does not exist. No pool available for key (" + key + ") !!");
        }
        pool.dispose(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerResponseFuture<.NoneType> shutdown() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._state == State.SHUTTING_DOWN || this._state == State.SHUTDOWN) {
                return this._shutdownFuture;
            }
            this._state = State.SHUTTING_DOWN;
            ArrayList futureList = new ArrayList();
            for (Map.Entry poolEntry : this._keyedPool.entrySet()) {
                AsyncResponseFuture<.NoneType> shutdownFuture = new AsyncResponseFuture<.NoneType>((ServerInstance)poolEntry.getKey(), "ConnPool shutdown future for pool entry " + poolEntry.getKey());
                ((AsyncPool)poolEntry.getValue()).shutdown(shutdownFuture);
                futureList.add(shutdownFuture);
                Collection waiters = ((AsyncPool)poolEntry.getValue()).cancelWaiters();
                if (null == waiters || waiters.isEmpty()) continue;
                Exception ex = new Exception("Pool is shutting down !!");
                for (Callback w : waiters) {
                    w.onError(ex);
                }
                ((AsyncPool)poolEntry.getValue()).shutdown(shutdownFuture);
            }
            this._shutdownFuture = new CompositeFuture("Shutdown For Pool", CompositeFuture.GatherModeOnError.AND);
            this._shutdownFuture.start(futureList);
            this._shutdownFuture.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = KeyedPoolImpl.this._mutex;
                    synchronized (object) {
                        KeyedPoolImpl.this._state = State.SHUTDOWN;
                    }
                }
            }, null);
        }
        return this._shutdownFuture;
    }

    @Override
    public PoolStats<Histogram> getStats() {
        return this._poolStats;
    }

    @Override
    public boolean validatePool(ServerInstance key, boolean recreate) {
        AsyncPool pool = (AsyncPool)this._keyedPool.get(key);
        if (pool != null) {
            return pool.validate(recreate);
        }
        return true;
    }

    private static enum State {
        INIT,
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

