/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.$internal.org.jboss.netty.handler.traffic;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pinot.;
import org.apache.pinot.$internal.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.pinot.$internal.org.jboss.netty.channel.Channel;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.pinot.$internal.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.MessageEvent;
import org.apache.pinot.$internal.org.jboss.netty.channel.SimpleChannelHandler;
import org.apache.pinot.$internal.org.jboss.netty.handler.traffic.TrafficCounter;
import org.apache.pinot.$internal.org.jboss.netty.logging.InternalLogger;
import org.apache.pinot.$internal.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.pinot.$internal.org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.apache.pinot.$internal.org.jboss.netty.util.ExternalResourceReleasable;
import org.apache.pinot.$internal.org.jboss.netty.util.ObjectSizeEstimator;
import org.apache.pinot.$internal.org.jboss.netty.util.Timeout;
import org.apache.pinot.$internal.org.jboss.netty.util.Timer;
import org.apache.pinot.$internal.org.jboss.netty.util.TimerTask;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    public static final long DEFAULT_MAX_TIME = 15000L;
    static final long DEFAULT_MAX_SIZE = 0x400000L;
    static final long MINIMAL_WAIT = 10L;
    static final int CHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 1;
    static final int GLOBAL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 2;
    static final int GLOBALCHANNEL_DEFAULT_USER_DEFINED_WRITABILITY_INDEX = 3;
    protected TrafficCounter trafficCounter;
    private ObjectSizeEstimator objectSizeEstimator;
    protected Timer timer;
    volatile Timeout timeout;
    private volatile long writeLimit;
    private volatile long readLimit;
    protected volatile long checkInterval = 1000L;
    protected volatile long maxTime = 15000L;
    volatile long maxWriteDelay = 4000L;
    volatile long maxWriteSize = 0x400000L;
    final AtomicBoolean release = new AtomicBoolean(false);
    final int index = this.userDefinedWritabilityIndex();

    int userDefinedWritabilityIndex() {
        if (this instanceof .GlobalChannelTrafficShapingHandler) {
            return 3;
        }
        if (this instanceof .GlobalTrafficShapingHandler) {
            return 2;
        }
        return 1;
    }

    private void init(ObjectSizeEstimator newObjectSizeEstimator, Timer newTimer, long newWriteLimit, long newReadLimit, long newCheckInterval, long newMaxTime) {
        if (newMaxTime <= 0L) {
            throw new IllegalArgumentException("maxTime must be positive");
        }
        this.objectSizeEstimator = newObjectSizeEstimator;
        this.timer = newTimer;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
        this.maxTime = newMaxTime;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(new SimpleObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        this.init(new SimpleObjectSizeEstimator(), timer, writeLimit, readLimit, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer) {
        this.init(new SimpleObjectSizeEstimator(), timer, 0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        this.init(objectSizeEstimator, timer, 0L, 0L, 1000L, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long checkInterval) {
        this.init(new SimpleObjectSizeEstimator(), timer, 0L, 0L, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        this.init(objectSizeEstimator, timer, 0L, 0L, checkInterval, 15000L);
    }

    protected AbstractTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        this.init(new SimpleObjectSizeEstimator(), timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    protected AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        this.init(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public void configure(long newCheckInterval) {
        this.setCheckInterval(newCheckInterval);
    }

    public long getWriteLimit() {
        return this.writeLimit;
    }

    public void setWriteLimit(long writeLimit) {
        this.writeLimit = writeLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getReadLimit() {
        return this.readLimit;
    }

    public void setReadLimit(long readLimit) {
        this.readLimit = readLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(TrafficCounter.milliSecondFromNano());
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    public long getMaxTimeWait() {
        return this.maxTime;
    }

    public void setMaxTimeWait(long maxTime) {
        if (maxTime <= 0L) {
            throw new IllegalArgumentException("maxTime must be positive");
        }
        this.maxTime = maxTime;
    }

    public long getMaxWriteDelay() {
        return this.maxWriteDelay;
    }

    public void setMaxWriteDelay(long maxWriteDelay) {
        if (maxWriteDelay <= 0L) {
            throw new IllegalArgumentException("maxWriteDelay must be positive");
        }
        this.maxWriteDelay = maxWriteDelay;
    }

    public long getMaxWriteSize() {
        return this.maxWriteSize;
    }

    public void setMaxWriteSize(long maxWriteSize) {
        this.maxWriteSize = maxWriteSize;
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    void releaseReadSuspended(ChannelHandlerContext ctx) {
        ReadWriteStatus rws = AbstractTrafficShapingHandler.checkAttachment(ctx);
        rws.readSuspend = false;
        ctx.getChannel().setReadable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        long now;
        block8: {
            block9: {
                now = TrafficCounter.milliSecondFromNano();
                try {
                    ReadWriteStatus rws = AbstractTrafficShapingHandler.checkAttachment(ctx);
                    long size = this.calculateSize(evt.getMessage());
                    if (size <= 0L || this.trafficCounter == null) break block8;
                    long wait = this.trafficCounter.readTimeToWait(size, this.readLimit, this.maxTime, now);
                    if ((wait = this.checkWaitReadTime(ctx, wait, now)) < 10L) break block8;
                    if (this.release.get()) {
                        Object var12_7 = null;
                        this.informReadOperation(ctx, now);
                        ctx.sendUpstream(evt);
                        return;
                    }
                    Channel channel = ctx.getChannel();
                    if (channel == null || !channel.isConnected()) break block8;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Read suspend: " + wait + ':' + channel.isReadable() + ':' + rws.readSuspend);
                    }
                    if (this.timer == null) {
                        Thread.sleep(wait);
                        break block9;
                    }
                    if (channel.isReadable() && !rws.readSuspend) {
                        rws.readSuspend = true;
                        channel.setReadable(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Suspend final status => " + channel.isReadable() + ':' + rws.readSuspend);
                        }
                        if (rws.reopenReadTimerTask == null) {
                            rws.reopenReadTimerTask = new ReopenReadTimerTask(ctx);
                        }
                        this.timeout = this.timer.newTimeout(rws.reopenReadTimerTask, wait, TimeUnit.MILLISECONDS);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    this.informReadOperation(ctx, now);
                    ctx.sendUpstream(evt);
                    throw throwable;
                }
            }
            Object var12_8 = null;
            this.informReadOperation(ctx, now);
            ctx.sendUpstream(evt);
            return;
        }
        Object var12_9 = null;
        this.informReadOperation(ctx, now);
        ctx.sendUpstream(evt);
    }

    long checkWaitReadTime(ChannelHandlerContext ctx, long wait, long now) {
        return wait;
    }

    void informReadOperation(ChannelHandlerContext ctx, long now) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        long wait = 0L;
        long size = this.calculateSize(evt.getMessage());
        long now = TrafficCounter.milliSecondFromNano();
        Channel channel = ctx.getChannel();
        try {
            if (size > 0L && this.trafficCounter != null) {
                wait = this.trafficCounter.writeTimeToWait(size, this.writeLimit, this.maxTime, now);
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + wait + ':' + channel.isWritable() + ':' + channel.getUserDefinedWritability(this.index));
                }
                if (wait < 10L || this.release.get()) {
                    wait = 0L;
                }
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.submitWrite(ctx, evt, size, wait, now);
            throw throwable;
        }
        this.submitWrite(ctx, evt, size, wait, now);
    }

    @Deprecated
    protected void internalSubmitWrite(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        ctx.sendDownstream(evt);
    }

    @Deprecated
    protected void submitWrite(ChannelHandlerContext ctx, MessageEvent evt, long delay) throws Exception {
        this.submitWrite(ctx, evt, this.calculateSize(evt.getMessage()), delay, TrafficCounter.milliSecondFromNano());
    }

    abstract void submitWrite(ChannelHandlerContext var1, MessageEvent var2, long var3, long var5, long var7) throws Exception;

    void setWritable(ChannelHandlerContext ctx, boolean writable) {
        Channel channel = ctx.getChannel();
        if (channel.isConnected()) {
            channel.setUserDefinedWritability(this.index, writable);
        }
    }

    void checkWriteSuspend(ChannelHandlerContext ctx, long delay, long queueSize) {
        if (queueSize > this.maxWriteSize || delay > this.maxWriteDelay) {
            this.setWritable(ctx, false);
        }
    }

    void releaseWriteSuspended(ChannelHandlerContext ctx) {
        this.setWritable(ctx, true);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    static ReadWriteStatus checkAttachment(ChannelHandlerContext ctx) {
        ReadWriteStatus rws = (ReadWriteStatus)ctx.getAttachment();
        if (rws == null) {
            rws = new ReadWriteStatus();
            ctx.setAttachment(rws);
        }
        return rws;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        AbstractTrafficShapingHandler.checkAttachment(ctx);
        this.setWritable(ctx, true);
        super.channelConnected(ctx, e);
    }

    protected long calculateSize(Object obj) {
        return this.objectSizeEstimator.estimateSize(obj);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(290).append("TrafficShaping with Write Limit: ").append(this.writeLimit).append(" Read Limit: ").append(this.readLimit).append(" CheckInterval: ").append(this.checkInterval).append(" maxDelay: ").append(this.maxWriteDelay).append(" maxSize: ").append(this.maxWriteSize).append(" and Counter: ");
        if (this.trafficCounter != null) {
            builder.append(this.trafficCounter);
        } else {
            builder.append("none");
        }
        return builder.toString();
    }

    class ReopenReadTimerTask
    implements TimerTask {
        final ChannelHandlerContext ctx;

        ReopenReadTimerTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeoutArg) throws Exception {
            if (AbstractTrafficShapingHandler.this.release.get()) {
                return;
            }
            ReadWriteStatus rws = AbstractTrafficShapingHandler.checkAttachment(this.ctx);
            Channel channel = this.ctx.getChannel();
            if (!channel.isConnected()) {
                return;
            }
            if (!channel.isReadable() && !rws.readSuspend) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not unsuspend: " + channel.isReadable() + ':' + rws.readSuspend);
                }
                rws.readSuspend = false;
            } else {
                if (logger.isDebugEnabled()) {
                    if (channel.isReadable() && rws.readSuspend) {
                        logger.debug("Unsuspend: " + channel.isReadable() + ':' + rws.readSuspend);
                    } else {
                        logger.debug("Normal unsuspend: " + channel.isReadable() + ':' + rws.readSuspend);
                    }
                }
                rws.readSuspend = false;
                channel.setReadable(true);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Unsupsend final status => " + channel.isReadable() + ':' + rws.readSuspend);
            }
        }
    }

    public static class SimpleObjectSizeEstimator
    extends DefaultObjectSizeEstimator {
        public int estimateSize(Object o) {
            int size = o instanceof ChannelBuffer ? ((ChannelBuffer)o).readableBytes() : super.estimateSize(o);
            return size;
        }
    }

    static final class ReadWriteStatus {
        volatile boolean readSuspend;
        volatile TimerTask reopenReadTimerTask;

        ReadWriteStatus() {
        }
    }
}

