/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.utils.EqualityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ColumnPartitionConfig {
    public static final String PARTITION_VALUE_DELIMITER = ",";
    @ConfigKey(value="functionName")
    private String _functionName;
    @ConfigKey(value="numPartitions")
    private int _numPartitions;

    public ColumnPartitionConfig() {
    }

    public ColumnPartitionConfig(@Nonnull @JsonProperty(value="functionName") String functionName, @JsonProperty(value="numPartitions") int numPartitions) {
        this._functionName = functionName;
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions must be > zero, specified: " + numPartitions);
        this._numPartitions = numPartitions;
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions must be > zero, specified: " + numPartitions);
        this._numPartitions = numPartitions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColumnPartitionConfig) {
            ColumnPartitionConfig that = (ColumnPartitionConfig)obj;
            return this._functionName.equals(that._functionName) && this._numPartitions == that._numPartitions;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = EqualityUtils.hashCodeOf(this._functionName);
        hashCode = EqualityUtils.hashCodeOf(hashCode, this._numPartitions);
        return hashCode;
    }

    public String toString() {
        return "ColumnPartitionConfig{_functionName='" + this._functionName + '\'' + ", _numPartitions=" + this._numPartitions + '}';
    }
}

