/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pinot.common.config.AdjustTableNameChildKeyTransformer;
import org.apache.pinot.common.config.CombinedConfigSeparatorChildKeyTransformer;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.RemapTableTypesChildKeyTransformer;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.UseChildKeyTransformers;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;

@UseChildKeyTransformers(value={AdjustTableNameChildKeyTransformer.class, RemapTableTypesChildKeyTransformer.class, CombinedConfigSeparatorChildKeyTransformer.class})
public class CombinedConfig {
    @ConfigKey(value="offline")
    private TableConfig _offline;
    @ConfigKey(value="realtime")
    private TableConfig _realtime;
    @ConfigKey(value="schema")
    private Schema _schema;

    public String toString() {
        try {
            return JsonUtils.objectToPrettyString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public TableConfig getOfflineTableConfig() {
        return this._offline;
    }

    public TableConfig getRealtimeTableConfig() {
        return this._realtime;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void setOffline(TableConfig offline) {
        this._offline = offline;
    }

    public void setRealtime(TableConfig realtime) {
        this._realtime = realtime;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public CombinedConfig(TableConfig offline, TableConfig realtime, Schema schema) {
        this._offline = offline;
        this._realtime = realtime;
        this._schema = schema;
    }

    public CombinedConfig() {
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        CombinedConfig that = (CombinedConfig)o;
        return EqualityUtils.isEqual(this._offline, that._offline) && EqualityUtils.isEqual(this._realtime, that._realtime) && EqualityUtils.isEqual(this._schema, that._schema);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._offline);
        result = EqualityUtils.hashCodeOf(result, this._realtime);
        result = EqualityUtils.hashCodeOf(result, this._schema);
        return result;
    }
}

