/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.io.File;
import java.util.Arrays;
import org.apache.pinot.common.config.CombinedConfig;
import org.apache.pinot.common.config.Deserializer;
import org.apache.pinot.common.utils.EqualityUtils;

public class CombinedConfigLoader {
    private static final String PROFILE_SEPARATOR = "___";

    static Map<String, ?> loadConfigFromFile(File file, String ... profiles) {
        ConfigParseOptions options = ConfigParseOptions.defaults().prependIncluder(new ConfigIncluder(){
            private ConfigIncluder parent = null;

            public ConfigObject include(ConfigIncludeContext context, String what) {
                File file = new File(what);
                if (!file.exists()) {
                    file = new File("profiles", what);
                }
                return ConfigFactory.parseFileAnySyntax((File)file).root();
            }

            public ConfigIncluder withFallback(ConfigIncluder fallback) {
                this.parent = fallback;
                return this;
            }
        });
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)options);
        for (String profile : profiles) {
            Config profileConfig = ConfigFactory.parseFile((File)new File("profiles", profile + ".conf"), (ConfigParseOptions)options);
            config = config.withFallback((ConfigMergeable)profileConfig);
        }
        config = config.resolve();
        config = CombinedConfigLoader.processProfileConditionals(config, profiles);
        return HashSet.ofAll((Iterable)config.entrySet()).toMap(entry -> Tuple.of(entry.getKey(), (Object)((ConfigValue)entry.getValue()).unwrapped()));
    }

    private static Config processProfileConditionals(Config config, String ... profiles) {
        HashSet enabledProfiles = HashSet.ofAll(Arrays.asList(profiles));
        Map configMap = HashSet.ofAll((Iterable)config.entrySet()).toMap(entry -> Tuple.of(entry.getKey(), entry.getValue()));
        Set profileKeys = configMap.keySet().filter(key -> key.contains(PROFILE_SEPARATOR)).toSet();
        Set enabledProfileKeys = profileKeys.filter(arg_0 -> CombinedConfigLoader.lambda$processProfileConditionals$43((Set)enabledProfiles, arg_0));
        HashMap overrideConfigMap = HashMap.empty();
        for (String enabledProfileKey : enabledProfileKeys) {
            int lastUnderscoreIndex;
            String destinationKey = enabledProfileKey.substring(0, lastUnderscoreIndex = enabledProfileKey.lastIndexOf(PROFILE_SEPARATOR));
            if (!overrideConfigMap.containsKey((Object)destinationKey)) {
                overrideConfigMap = overrideConfigMap.put(Tuple.of((Object)destinationKey, (Object)config.getValue(enabledProfileKey)));
                continue;
            }
            ConfigValue previousOverrideValue = (ConfigValue)overrideConfigMap.get((Object)destinationKey).get();
            ConfigValue newConfigValue = config.getValue(enabledProfileKey);
            if (EqualityUtils.isEqual(previousOverrideValue.unwrapped(), newConfigValue.unwrapped())) continue;
            throw new RuntimeException("Found conflicting value for key " + destinationKey + " due to multiple enabled profiles for this configuration key. Previous override was " + previousOverrideValue.unwrapped() + ", new override value is " + newConfigValue.unwrapped() + ". Ensure that all enabled profiles for this profile override key have the same resulting value.");
        }
        for (String profileKey : profileKeys) {
            config = config.withoutPath(profileKey);
        }
        config = ConfigFactory.parseMap((java.util.Map)overrideConfigMap.toJavaMap()).withFallback((ConfigMergeable)config);
        return config;
    }

    static Map<String, ?> loadConfigFromString(String string) {
        Config config = ConfigFactory.parseString((String)string, (ConfigParseOptions)ConfigParseOptions.defaults().prependIncluder(new ConfigIncluder(){
            private ConfigIncluder parent = null;

            public ConfigObject include(ConfigIncludeContext context, String what) {
                return ConfigFactory.parseFileAnySyntax((File)new File(what)).root();
            }

            public ConfigIncluder withFallback(ConfigIncluder fallback) {
                this.parent = fallback;
                return this;
            }
        }));
        config = config.resolve();
        return HashSet.ofAll((Iterable)config.entrySet()).toMap(entry -> Tuple.of(entry.getKey(), (Object)((ConfigValue)entry.getValue()).unwrapped()));
    }

    public static CombinedConfig loadCombinedConfig(Map<String, ?> config) {
        try {
            return Deserializer.deserialize(CombinedConfig.class, config, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CombinedConfig loadCombinedConfig(java.util.Map<String, ?> config) {
        return CombinedConfigLoader.loadCombinedConfig(HashMap.ofAll(config));
    }

    public static CombinedConfig loadCombinedConfig(File file, String ... profiles) {
        return CombinedConfigLoader.loadCombinedConfig(CombinedConfigLoader.loadConfigFromFile(file, profiles));
    }

    public static CombinedConfig loadCombinedConfig(String string) {
        return CombinedConfigLoader.loadCombinedConfig(CombinedConfigLoader.loadConfigFromString(string));
    }

    private static /* synthetic */ boolean lambda$processProfileConditionals$43(Set set, String key) {
        int lastUnderscoreIndex = key.lastIndexOf(PROFILE_SEPARATOR);
        String profile = key.substring(lastUnderscoreIndex + PROFILE_SEPARATOR.length(), key.length());
        return set.contains((Object)profile);
    }
}

