/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TagConfig;
import org.apache.pinot.common.config.TagNameUtils;
import org.apache.pinot.common.config.TagOverrideConfig;

public class RealtimeTagConfig
extends TagConfig {
    private String _consumingRealtimeServerTag;
    private String _completedRealtimeServerTag;
    private boolean _relocateCompletedSegments = false;

    public RealtimeTagConfig(TableConfig tableConfig) {
        super(tableConfig);
        TagOverrideConfig tagOverrideConfig = tableConfig.getTenantConfig().getTagOverrideConfig();
        this._consumingRealtimeServerTag = tagOverrideConfig != null && tagOverrideConfig.getRealtimeConsuming() != null ? tagOverrideConfig.getRealtimeConsuming() : TagNameUtils.getRealtimeTagForTenant(this._serverTenant);
        this._completedRealtimeServerTag = tagOverrideConfig != null && tagOverrideConfig.getRealtimeCompleted() != null ? tagOverrideConfig.getRealtimeCompleted() : TagNameUtils.getRealtimeTagForTenant(this._serverTenant);
        if (!this._consumingRealtimeServerTag.equals(this._completedRealtimeServerTag)) {
            this._relocateCompletedSegments = true;
        }
    }

    public String getConsumingServerTag() {
        return this._consumingRealtimeServerTag;
    }

    public String getCompletedServerTag() {
        return this._completedRealtimeServerTag;
    }

    public boolean isRelocateCompletedSegments() {
        return this._relocateCompletedSegments;
    }
}

