/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import java.util.Collection;
import java.util.function.Function;
import org.apache.pinot.common.config.ChildKeyTransformer;

public class RemapTableTypesChildKeyTransformer
implements ChildKeyTransformer {
    @Override
    public Map<String, ?> apply(Map<String, ?> config, String keyPrefix) {
        config = config.merge((Map)config.get((Object)"table.types").map(typeList -> {
            if (typeList instanceof String) {
                return List.of((Object)((String)typeList));
            }
            if (typeList instanceof Collection) {
                return List.ofAll((Iterable)((Collection)typeList));
            }
            return List.empty();
        }).map(typeList -> typeList.map(type -> Tuple.of((Object)("table.type." + type.toString().toLowerCase()), (Object)type)).toMap(Function.identity())).getOrElse(HashMap::empty));
        config = config.remove((Object)"table.types");
        return config;
    }

    @Override
    public Map<String, ?> unapply(Map<String, ?> config, String keyPrefix) {
        Map tableTypeMap = config.filterKeys(key -> key.startsWith("table.type."));
        java.util.List tableTypes = tableTypeMap.values().map(Object::toString).toSet().toJavaList();
        Map remappedConfig = config.removeAll((Iterable)tableTypeMap.keySet()).put((Object)"table.types", (Object)tableTypes);
        return remappedConfig;
    }
}

