/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Field;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.DurationDsl;
import org.apache.pinot.common.config.NestedConfig;
import org.apache.pinot.common.config.ReplicaGroupStrategyConfig;
import org.apache.pinot.common.config.UseDsl;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.startree.hll.HllConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentsValidationAndRetentionConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentsValidationAndRetentionConfig.class);
    @ConfigKey(value="retention")
    @UseDsl(dsl=DurationDsl.class, value="unit")
    private String retentionTimeUnit;
    @ConfigKey(value="retention")
    @UseDsl(dsl=DurationDsl.class, value="unitCount")
    private String retentionTimeValue;
    @ConfigKey(value="segmentPushFrequency")
    private String segmentPushFrequency;
    @ConfigKey(value="segmentPushType")
    private String segmentPushType;
    @ConfigKey(value="replication")
    private String replication;
    @ConfigKey(value="schemaName")
    private String schemaName;
    @ConfigKey(value="timeColumnName")
    private String timeColumnName;
    @ConfigKey(value="timeType")
    private String timeType;
    @ConfigKey(value="segmentAssignmentStrategy")
    private String segmentAssignmentStrategy;
    @NestedConfig
    private ReplicaGroupStrategyConfig replicaGroupStrategyConfig;
    @NestedConfig
    private HllConfig hllConfig;
    @ConfigKey(value="replicasPerPartition")
    private String replicasPerPartition;

    public String getSegmentAssignmentStrategy() {
        return this.segmentAssignmentStrategy;
    }

    public void setSegmentAssignmentStrategy(String segmentAssignmentStrategy) {
        this.segmentAssignmentStrategy = segmentAssignmentStrategy;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setTimeColumnName(String timeColumnName) {
        this.timeColumnName = timeColumnName;
    }

    public String getTimeType() {
        return this.timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public String getRetentionTimeUnit() {
        return this.retentionTimeUnit;
    }

    public void setRetentionTimeUnit(String retentionTimeUnit) {
        this.retentionTimeUnit = retentionTimeUnit;
    }

    public String getRetentionTimeValue() {
        return this.retentionTimeValue;
    }

    public void setRetentionTimeValue(String retentionTimeValue) {
        this.retentionTimeValue = retentionTimeValue;
    }

    public String getSegmentPushFrequency() {
        return this.segmentPushFrequency;
    }

    public void setSegmentPushFrequency(String segmentPushFrequency) {
        this.segmentPushFrequency = segmentPushFrequency;
    }

    public String getSegmentPushType() {
        return this.segmentPushType;
    }

    public void setSegmentPushType(String segmentPushType) {
        this.segmentPushType = segmentPushType;
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getReplicasPerPartition() {
        return this.replicasPerPartition;
    }

    public void setReplicasPerPartition(String replicasPerPartition) {
        this.replicasPerPartition = replicasPerPartition;
    }

    public ReplicaGroupStrategyConfig getReplicaGroupStrategyConfig() {
        return this.replicaGroupStrategyConfig;
    }

    public void setReplicaGroupStrategyConfig(ReplicaGroupStrategyConfig replicaGroupStrategyConfig) {
        this.replicaGroupStrategyConfig = replicaGroupStrategyConfig;
    }

    public HllConfig getHllConfig() {
        return this.hllConfig;
    }

    public void setHllConfig(HllConfig hllConfig) {
        this.hllConfig = hllConfig;
    }

    @JsonIgnore
    public int getReplicationNumber() {
        return Integer.parseInt(this.replication);
    }

    @JsonIgnore
    public int getReplicasPerPartitionNumber() {
        return Integer.parseInt(this.replicasPerPartition);
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            block3: {
                result.append("  ");
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                }
                catch (IllegalAccessException ex) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Caught exception while processing field " + field, (Throwable)ex);
                }
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        SegmentsValidationAndRetentionConfig that = (SegmentsValidationAndRetentionConfig)o;
        return EqualityUtils.isEqual(this.retentionTimeUnit, that.retentionTimeUnit) && EqualityUtils.isEqual(this.retentionTimeValue, that.retentionTimeValue) && EqualityUtils.isEqual(this.segmentPushFrequency, that.segmentPushFrequency) && EqualityUtils.isEqual(this.segmentPushType, that.segmentPushType) && EqualityUtils.isEqual(this.replication, that.replication) && EqualityUtils.isEqual(this.schemaName, that.schemaName) && EqualityUtils.isEqual(this.timeColumnName, that.timeColumnName) && EqualityUtils.isEqual(this.timeType, that.timeType) && EqualityUtils.isEqual(this.segmentAssignmentStrategy, that.segmentAssignmentStrategy) && EqualityUtils.isEqual(this.replicaGroupStrategyConfig, that.replicaGroupStrategyConfig) && EqualityUtils.isEqual(this.hllConfig, that.hllConfig) && EqualityUtils.isEqual(this.replicasPerPartition, that.replicasPerPartition);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this.retentionTimeUnit);
        result = EqualityUtils.hashCodeOf(result, this.retentionTimeValue);
        result = EqualityUtils.hashCodeOf(result, this.segmentPushFrequency);
        result = EqualityUtils.hashCodeOf(result, this.segmentPushType);
        result = EqualityUtils.hashCodeOf(result, this.replication);
        result = EqualityUtils.hashCodeOf(result, this.schemaName);
        result = EqualityUtils.hashCodeOf(result, this.timeColumnName);
        result = EqualityUtils.hashCodeOf(result, this.timeType);
        result = EqualityUtils.hashCodeOf(result, this.segmentAssignmentStrategy);
        result = EqualityUtils.hashCodeOf(result, this.replicaGroupStrategyConfig);
        result = EqualityUtils.hashCodeOf(result, this.hllConfig);
        result = EqualityUtils.hashCodeOf(result, this.replicasPerPartition);
        return result;
    }
}

