/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.utils.CommonConstants;

public class TableNameBuilder {
    public static final TableNameBuilder OFFLINE = new TableNameBuilder(CommonConstants.Helix.TableType.OFFLINE);
    public static final TableNameBuilder REALTIME = new TableNameBuilder(CommonConstants.Helix.TableType.REALTIME);
    private static final String TYPE_SUFFIX_SEPARATOR = "_";
    private final String _typeSuffix;

    private TableNameBuilder(@Nonnull CommonConstants.Helix.TableType tableType) {
        this._typeSuffix = TYPE_SUFFIX_SEPARATOR + tableType.toString();
    }

    @Nonnull
    public static TableNameBuilder forType(@Nonnull CommonConstants.Helix.TableType tableType) {
        if (tableType == CommonConstants.Helix.TableType.OFFLINE) {
            return OFFLINE;
        }
        return REALTIME;
    }

    @Nonnull
    public String tableNameWithType(@Nonnull String tableName) {
        Preconditions.checkArgument(!tableName.contains("__"), "Table name: %s cannot contain two consecutive underscore characters", (Object)tableName);
        if (tableName.endsWith(this._typeSuffix)) {
            return tableName;
        }
        return tableName + this._typeSuffix;
    }

    public boolean tableHasTypeSuffix(@Nonnull String tableName) {
        return tableName.endsWith(this._typeSuffix);
    }

    @Nullable
    public static CommonConstants.Helix.TableType getTableTypeFromTableName(@Nonnull String tableName) {
        if (OFFLINE.tableHasTypeSuffix(tableName)) {
            return CommonConstants.Helix.TableType.OFFLINE;
        }
        if (REALTIME.tableHasTypeSuffix(tableName)) {
            return CommonConstants.Helix.TableType.REALTIME;
        }
        return null;
    }

    @Nonnull
    public static String extractRawTableName(@Nonnull String tableName) {
        if (OFFLINE.tableHasTypeSuffix(tableName)) {
            return tableName.substring(0, tableName.length() - TableNameBuilder.OFFLINE._typeSuffix.length());
        }
        if (REALTIME.tableHasTypeSuffix(tableName)) {
            return tableName.substring(0, tableName.length() - TableNameBuilder.REALTIME._typeSuffix.length());
        }
        return tableName;
    }

    public static boolean isTableResource(@Nonnull String resourceName) {
        return OFFLINE.tableHasTypeSuffix(resourceName) || REALTIME.tableHasTypeSuffix(resourceName);
    }
}

