/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.TaskConfigMapChildKeyHandler;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.utils.EqualityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableTaskConfig {
    @ConfigKey(value="taskConfig")
    @UseChildKeyHandler(value=TaskConfigMapChildKeyHandler.class)
    private Map<String, Map<String, String>> _taskTypeConfigsMap;

    public void setTaskTypeConfigsMap(Map<String, Map<String, String>> taskTypeConfigsMap) {
        this._taskTypeConfigsMap = taskTypeConfigsMap;
    }

    public Map<String, Map<String, String>> getTaskTypeConfigsMap() {
        return this._taskTypeConfigsMap;
    }

    @JsonIgnore
    public boolean isTaskTypeEnabled(String taskType) {
        return this._taskTypeConfigsMap.containsKey(taskType);
    }

    @JsonIgnore
    public Map<String, String> getConfigsForTaskType(String taskType) {
        return this._taskTypeConfigsMap.get(taskType);
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        TableTaskConfig that = (TableTaskConfig)o;
        return EqualityUtils.isEqual(this._taskTypeConfigsMap, that._taskTypeConfigsMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._taskTypeConfigsMap);
        return result;
    }
}

