/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.reflect.Field;
import org.apache.pinot.common.config.ConfigDoc;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.TagOverrideConfig;
import org.apache.pinot.common.utils.EqualityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TenantConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantConfig.class);
    @ConfigKey(value="brokerTagPrefix")
    @ConfigDoc(value="Broker tag prefix used by this table")
    private String broker;
    @ConfigKey(value="serverTagPrefix")
    @ConfigDoc(value="Server tag prefix used by this table")
    private String server;
    @ConfigKey(value="tagOverrideConfig")
    @ConfigDoc(value="Overrides for tags")
    private TagOverrideConfig tagOverrideConfig;

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public TagOverrideConfig getTagOverrideConfig() {
        return this.tagOverrideConfig;
    }

    public void setTagOverrideConfig(TagOverrideConfig tagOverrideConfig) {
        this.tagOverrideConfig = tagOverrideConfig;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            block3: {
                result.append("  ");
                try {
                    result.append(field.getName());
                    result.append(": ");
                    result.append(field.get(this));
                }
                catch (IllegalAccessException ex) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Caught exception while processing field " + field, (Throwable)ex);
                }
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        TenantConfig that = (TenantConfig)o;
        return EqualityUtils.isEqual(this.broker, that.broker) && EqualityUtils.isEqual(this.server, that.server);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this.broker);
        result = EqualityUtils.hashCodeOf(result, this.server);
        return result;
    }
}

