/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.config;

import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import java.util.Map;
import org.apache.pinot.common.config.ChildKeyHandler;
import org.apache.pinot.common.config.Deserializer;
import org.apache.pinot.common.config.Serializer;

public class TypedMapChildKeyHandler<T>
implements ChildKeyHandler<Map<String, T>> {
    private Class<T> _type;

    protected TypedMapChildKeyHandler(Class<T> type) {
        this._type = type;
    }

    @Override
    public Map<String, T> handleChildKeys(io.vavr.collection.Map<String, ?> childKeys, String pathPrefix) {
        java.util.HashMap returnedMap = new java.util.HashMap();
        childKeys.groupBy(tuple2 -> ((String)tuple2._1).split("\\.", 2)[0]).map((key, values) -> {
            Object value;
            io.vavr.collection.Map valuesWithoutPrefix = values.map((configKey, configValue) -> Tuple.of((Object)configKey.substring(key.length() + 1), (Object)configValue));
            try {
                value = Deserializer.deserialize(this._type, valuesWithoutPrefix, "");
            }
            catch (Exception e) {
                value = null;
                e.printStackTrace();
            }
            return Tuple.of((Object)key, value);
        }).forEach(returnedMap::put);
        if (returnedMap.isEmpty()) {
            return null;
        }
        return returnedMap;
    }

    @Override
    public io.vavr.collection.Map<String, ?> unhandleChildKeys(Map<String, T> value, String pathPrefix) {
        if (value == null) {
            return null;
        }
        HashMap serialized = HashMap.ofAll(value).flatMap((columnName, columnPartitionConfig) -> Serializer.serialize(columnPartitionConfig).map((key, obj) -> Tuple.of((Object)(columnName + "." + key), (Object)obj)));
        return serialized;
    }
}

