/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.$internal.com.google.common.base.Joiner;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.common.utils.EqualityUtils;

public class DateTimeGranularitySpec {
    public static final String GRANULARITY_TOKENS_ERROR_STR = "granularity must be of format size:timeunit";
    public static final String GRANULARITY_PATTERN_ERROR_STR = "granularity must be of format [0-9]+:<TimeUnit>";
    public static final String NUMBER_REGEX = "[1-9][0-9]*";
    public static final String COLON_SEPARATOR = ":";
    public static final int GRANULARITY_SIZE_POSITION = 0;
    public static final int GRANULARITY_UNIT_POSITION = 1;
    public static final int MAX_GRANULARITY_TOKENS = 2;
    private String _granularity;
    private int _size;
    private TimeUnit _timeUnit;

    public DateTimeGranularitySpec(String granularity) {
        this._granularity = granularity;
        DateTimeGranularitySpec.isValidGranularity(granularity);
        String[] granularityTokens = this._granularity.split(COLON_SEPARATOR);
        this._size = Integer.valueOf(granularityTokens[0]);
        this._timeUnit = TimeUnit.valueOf(granularityTokens[1]);
    }

    public DateTimeGranularitySpec(int columnSize, TimeUnit columnUnit) {
        this._granularity = Joiner.on(COLON_SEPARATOR).join(columnSize, (Object)columnUnit, new Object[0]);
        this._size = columnSize;
        this._timeUnit = columnUnit;
        DateTimeGranularitySpec.isValidGranularity(this._granularity);
    }

    public String getGranularity() {
        return this._granularity;
    }

    public int getSize() {
        return this._size;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public Long granularityToMillis() {
        return TimeUnit.MILLISECONDS.convert(this._size, this._timeUnit);
    }

    public static boolean isValidGranularity(String granularity) {
        Preconditions.checkNotNull(granularity);
        String[] granularityTokens = granularity.split(COLON_SEPARATOR);
        Preconditions.checkArgument(granularityTokens.length == 2, GRANULARITY_TOKENS_ERROR_STR);
        Preconditions.checkArgument(granularityTokens[0].matches(NUMBER_REGEX), GRANULARITY_PATTERN_ERROR_STR);
        Preconditions.checkArgument(EnumUtils.isValidEnum(TimeUnit.class, granularityTokens[1]), GRANULARITY_PATTERN_ERROR_STR);
        return true;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeGranularitySpec that = (DateTimeGranularitySpec)o;
        return EqualityUtils.isEqual(this._granularity, that._granularity);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._granularity);
        return result;
    }
}

