/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.config.UseChildKeyHandler;
import org.apache.pinot.common.data.DateTimeFieldSpec;
import org.apache.pinot.common.data.DateTimeFieldSpecChildKeyHandler;
import org.apache.pinot.common.data.DimensionFieldSpec;
import org.apache.pinot.common.data.DimensionFieldSpecChildKeyHandler;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.data.MetricFieldSpec;
import org.apache.pinot.common.data.MetricFieldSpecChildKeyHandler;
import org.apache.pinot.common.data.TimeFieldSpec;
import org.apache.pinot.common.data.TimeGranularitySpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Schema {
    private static final Logger LOGGER = LoggerFactory.getLogger(Schema.class);
    @ConfigKey(value="schemaName")
    private String _schemaName;
    @ConfigKey(value="dimensions")
    @UseChildKeyHandler(value=DimensionFieldSpecChildKeyHandler.class)
    private final List<DimensionFieldSpec> _dimensionFieldSpecs = new ArrayList<DimensionFieldSpec>();
    @ConfigKey(value="metrics")
    @UseChildKeyHandler(value=MetricFieldSpecChildKeyHandler.class)
    private final List<MetricFieldSpec> _metricFieldSpecs = new ArrayList<MetricFieldSpec>();
    @ConfigKey(value="time")
    private TimeFieldSpec _timeFieldSpec;
    @ConfigKey(value="dateTime")
    @UseChildKeyHandler(value=DateTimeFieldSpecChildKeyHandler.class)
    private final List<DateTimeFieldSpec> _dateTimeFieldSpecs = new ArrayList<DateTimeFieldSpec>();
    private final transient Map<String, FieldSpec> _fieldSpecMap = new HashMap<String, FieldSpec>();
    private final transient List<String> _dimensionNames = new ArrayList<String>();
    private final transient List<String> _metricNames = new ArrayList<String>();
    private final transient List<String> _dateTimeNames = new ArrayList<String>();

    @Nonnull
    public static Schema fromFile(@Nonnull File schemaFile) throws IOException {
        return JsonUtils.fileToObject(schemaFile, Schema.class);
    }

    @Nonnull
    public static Schema fromString(@Nonnull String schemaString) throws IOException {
        return JsonUtils.stringToObject(schemaString, Schema.class);
    }

    @Nonnull
    public static Schema fromInputSteam(@Nonnull InputStream schemaInputStream) throws IOException {
        return JsonUtils.inputStreamToObject(schemaInputStream, Schema.class);
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(@Nonnull String schemaName) {
        this._schemaName = schemaName;
    }

    @Nonnull
    public List<DimensionFieldSpec> getDimensionFieldSpecs() {
        return this._dimensionFieldSpecs;
    }

    @Deprecated
    public void setDimensionFieldSpecs(@Nonnull List<DimensionFieldSpec> dimensionFieldSpecs) {
        Preconditions.checkState(this._dimensionFieldSpecs.isEmpty());
        for (DimensionFieldSpec dimensionFieldSpec : dimensionFieldSpecs) {
            this.addField(dimensionFieldSpec);
        }
    }

    @Nonnull
    public List<MetricFieldSpec> getMetricFieldSpecs() {
        return this._metricFieldSpecs;
    }

    @Deprecated
    public void setMetricFieldSpecs(@Nonnull List<MetricFieldSpec> metricFieldSpecs) {
        Preconditions.checkState(this._metricFieldSpecs.isEmpty());
        for (MetricFieldSpec metricFieldSpec : metricFieldSpecs) {
            this.addField(metricFieldSpec);
        }
    }

    @Nonnull
    public List<DateTimeFieldSpec> getDateTimeFieldSpecs() {
        return this._dateTimeFieldSpecs;
    }

    @Deprecated
    public void setDateTimeFieldSpecs(@Nonnull List<DateTimeFieldSpec> dateTimeFieldSpecs) {
        Preconditions.checkState(this._dateTimeFieldSpecs.isEmpty());
        for (DateTimeFieldSpec dateTimeFieldSpec : dateTimeFieldSpecs) {
            this.addField(dateTimeFieldSpec);
        }
    }

    public TimeFieldSpec getTimeFieldSpec() {
        return this._timeFieldSpec;
    }

    @Deprecated
    public void setTimeFieldSpec(TimeFieldSpec timeFieldSpec) {
        if (timeFieldSpec != null) {
            this.addField(timeFieldSpec);
        }
    }

    public void addField(@Nonnull FieldSpec fieldSpec) {
        Preconditions.checkNotNull(fieldSpec);
        String columnName = fieldSpec.getName();
        Preconditions.checkNotNull(columnName);
        Preconditions.checkState(!this._fieldSpecMap.containsKey(columnName), "Field spec already exists for column: " + columnName);
        FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
        switch (fieldType) {
            case DIMENSION: {
                this._dimensionNames.add(columnName);
                this._dimensionFieldSpecs.add((DimensionFieldSpec)fieldSpec);
                break;
            }
            case METRIC: {
                this._metricNames.add(columnName);
                this._metricFieldSpecs.add((MetricFieldSpec)fieldSpec);
                break;
            }
            case TIME: {
                this._timeFieldSpec = (TimeFieldSpec)fieldSpec;
                break;
            }
            case DATE_TIME: {
                this._dateTimeNames.add(columnName);
                this._dateTimeFieldSpecs.add((DateTimeFieldSpec)fieldSpec);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported field type: " + (Object)((Object)fieldType));
            }
        }
        this._fieldSpecMap.put(columnName, fieldSpec);
    }

    @Deprecated
    public void addField(@Nonnull String columnName, @Nonnull FieldSpec fieldSpec) {
        this.addField(fieldSpec);
    }

    public boolean removeField(String columnName) {
        FieldSpec existingFieldSpec = this._fieldSpecMap.remove(columnName);
        if (existingFieldSpec != null) {
            FieldSpec.FieldType fieldType = existingFieldSpec.getFieldType();
            switch (fieldType) {
                case DIMENSION: {
                    int index = this._dimensionNames.indexOf(columnName);
                    this._dimensionNames.remove(index);
                    this._dimensionFieldSpecs.remove(index);
                    break;
                }
                case METRIC: {
                    int index = this._metricNames.indexOf(columnName);
                    this._metricNames.remove(index);
                    this._metricFieldSpecs.remove(index);
                    break;
                }
                case TIME: {
                    this._timeFieldSpec = null;
                    break;
                }
                case DATE_TIME: {
                    int index = this._dateTimeNames.indexOf(columnName);
                    this._dateTimeNames.remove(index);
                    this._dateTimeFieldSpecs.remove(index);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported field type: " + (Object)((Object)fieldType));
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasColumn(@Nonnull String columnName) {
        return this._fieldSpecMap.containsKey(columnName);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, FieldSpec> getFieldSpecMap() {
        return this._fieldSpecMap;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getColumnNames() {
        return this._fieldSpecMap.keySet();
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getPhysicalColumnNames() {
        HashSet<String> cols = new HashSet<String>();
        cols.addAll(this._fieldSpecMap.keySet());
        for (String col : this._fieldSpecMap.keySet()) {
            if (!this.isVirtualColumn(col)) continue;
            cols.remove(col);
        }
        return cols;
    }

    @JsonIgnore
    @Nonnull
    public Collection<FieldSpec> getAllFieldSpecs() {
        return this._fieldSpecMap.values();
    }

    public int size() {
        return this._fieldSpecMap.size();
    }

    @JsonIgnore
    public FieldSpec getFieldSpecFor(@Nonnull String columnName) {
        return this._fieldSpecMap.get(columnName);
    }

    @JsonIgnore
    public MetricFieldSpec getMetricSpec(@Nonnull String metricName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(metricName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
            return (MetricFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    public DimensionFieldSpec getDimensionSpec(@Nonnull String dimensionName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(dimensionName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.DIMENSION) {
            return (DimensionFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    public DateTimeFieldSpec getDateTimeSpec(@Nonnull String dateTimeName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(dateTimeName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.DATE_TIME) {
            return (DateTimeFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    @Nonnull
    public List<String> getDimensionNames() {
        return this._dimensionNames;
    }

    @JsonIgnore
    @Nonnull
    public List<String> getMetricNames() {
        return this._metricNames;
    }

    @JsonIgnore
    @Nonnull
    public List<String> getDateTimeNames() {
        return this._dateTimeNames;
    }

    @JsonIgnore
    public String getTimeColumnName() {
        return this._timeFieldSpec != null ? this._timeFieldSpec.getName() : null;
    }

    @JsonIgnore
    public TimeUnit getIncomingTimeUnit() {
        return this._timeFieldSpec != null ? this._timeFieldSpec.getIncomingGranularitySpec().getTimeType() : null;
    }

    @JsonIgnore
    public TimeUnit getOutgoingTimeUnit() {
        return this._timeFieldSpec != null ? this._timeFieldSpec.getOutgoingGranularitySpec().getTimeType() : null;
    }

    public ObjectNode toJsonObject() {
        ArrayNode jsonArray;
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("schemaName", this._schemaName);
        if (!this._dimensionFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (DimensionFieldSpec dimensionFieldSpec : this._dimensionFieldSpecs) {
                jsonArray.add((JsonNode)dimensionFieldSpec.toJsonObject());
            }
            jsonObject.set("dimensionFieldSpecs", (JsonNode)jsonArray);
        }
        if (!this._metricFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (MetricFieldSpec metricFieldSpec : this._metricFieldSpecs) {
                jsonArray.add((JsonNode)metricFieldSpec.toJsonObject());
            }
            jsonObject.set("metricFieldSpecs", (JsonNode)jsonArray);
        }
        if (this._timeFieldSpec != null) {
            jsonObject.set("timeFieldSpec", (JsonNode)this._timeFieldSpec.toJsonObject());
        }
        if (!this._dateTimeFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (DateTimeFieldSpec dateTimeFieldSpec : this._dateTimeFieldSpecs) {
                jsonArray.add((JsonNode)dateTimeFieldSpec.toJsonObject());
            }
            jsonObject.set("dateTimeFieldSpecs", (JsonNode)jsonArray);
        }
        return jsonObject;
    }

    @Nonnull
    public String toPrettyJsonString() {
        try {
            return JsonUtils.objectToPrettyString(this.toJsonObject());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String toSingleLineJsonString() {
        return this.toJsonObject().toString();
    }

    public boolean validate(Logger ctxLogger) {
        if (ctxLogger == null) {
            ctxLogger = LOGGER;
        }
        block11: for (FieldSpec fieldSpec : this._fieldSpecMap.values()) {
            FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            String fieldName = fieldSpec.getName();
            block0 : switch (fieldType) {
                case DIMENSION: 
                case TIME: 
                case DATE_TIME: {
                    switch (dataType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: 
                        case BYTES: {
                            break block0;
                        }
                    }
                    ctxLogger.info("Unsupported data type: {} in DIMENSION/TIME field: {}", (Object)dataType, (Object)fieldName);
                    return false;
                }
                case METRIC: {
                    switch (dataType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BYTES: {
                            break block0;
                        }
                        case STRING: {
                            MetricFieldSpec metricFieldSpec = (MetricFieldSpec)fieldSpec;
                            if (metricFieldSpec.isDerivedMetric()) continue block11;
                            ctxLogger.info("Unsupported data type: STRING in non-derived METRIC field: {}", (Object)fieldName);
                            return false;
                        }
                        default: {
                            ctxLogger.info("Unsupported data type: {} in METRIC field: {}", (Object)dataType, (Object)fieldName);
                            return false;
                        }
                    }
                }
                default: {
                    ctxLogger.info("Unsupported field type: {} for field: {}", (Object)dataType, (Object)fieldName);
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return this.toPrettyJsonString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        Schema that = (Schema)o;
        return EqualityUtils.isEqual(this._schemaName, that._schemaName) && EqualityUtils.isEqualIgnoreOrder(this._dimensionFieldSpecs, that._dimensionFieldSpecs) && EqualityUtils.isEqualIgnoreOrder(this._metricFieldSpecs, that._metricFieldSpecs) && EqualityUtils.isEqual(this._timeFieldSpec, that._timeFieldSpec) && EqualityUtils.isEqualIgnoreOrder(this._dateTimeFieldSpecs, that._dateTimeFieldSpecs);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._schemaName);
        result = EqualityUtils.hashCodeOf(result, this._dimensionFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._metricFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._timeFieldSpec);
        result = EqualityUtils.hashCodeOf(result, this._dateTimeFieldSpecs);
        return result;
    }

    public boolean isVirtualColumn(String columnName) {
        return columnName.startsWith("$") || this.getFieldSpecFor(columnName).getVirtualColumnProvider() != null && !this.getFieldSpecFor(columnName).getVirtualColumnProvider().isEmpty();
    }

    public static class SchemaBuilder {
        private Schema _schema = new Schema();

        public SchemaBuilder setSchemaName(@Nonnull String schemaName) {
            this._schema.setSchemaName(schemaName);
            return this;
        }

        public SchemaBuilder addSingleValueDimension(@Nonnull String dimensionName, @Nonnull FieldSpec.DataType dataType) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, true));
            return this;
        }

        public SchemaBuilder addSingleValueDimension(@Nonnull String dimensionName, @Nonnull FieldSpec.DataType dataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, true, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMultiValueDimension(@Nonnull String dimensionName, @Nonnull FieldSpec.DataType dataType) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, false));
            return this;
        }

        public SchemaBuilder addMultiValueDimension(@Nonnull String dimensionName, @Nonnull FieldSpec.DataType dataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, false, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMetric(@Nonnull String metricName, @Nonnull FieldSpec.DataType dataType) {
            this._schema.addField(new MetricFieldSpec(metricName, dataType));
            return this;
        }

        public SchemaBuilder addMetric(@Nonnull String metricName, @Nonnull FieldSpec.DataType dataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new MetricFieldSpec(metricName, dataType, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMetric(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, int fieldSize, @Nonnull MetricFieldSpec.DerivedMetricType derivedMetricType) {
            this._schema.addField(new MetricFieldSpec(name, dataType, fieldSize, derivedMetricType));
            return this;
        }

        public SchemaBuilder addMetric(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, int fieldSize, @Nonnull MetricFieldSpec.DerivedMetricType derivedMetricType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new MetricFieldSpec(name, dataType, fieldSize, derivedMetricType, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnit));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnit, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull String outgoingName, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull FieldSpec.DataType outgoingDataType) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnit, outgoingName, outgoingDataType, outgoingTimeUnit));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull String outgoingName, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull FieldSpec.DataType outgoingDataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnit, outgoingName, outgoingDataType, outgoingTimeUnit, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnitSize, incomingTimeUnit));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnitSize, incomingTimeUnit, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull String outgoingName, int outgoingTimeUnitSize, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull FieldSpec.DataType outgoingDataType) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnitSize, incomingTimeUnit, outgoingName, outgoingDataType, outgoingTimeUnitSize, outgoingTimeUnit));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull String incomingName, int incomingTimeUnitSize, @Nonnull TimeUnit incomingTimeUnit, @Nonnull FieldSpec.DataType incomingDataType, @Nonnull String outgoingName, int outgoingTimeUnitSize, @Nonnull TimeUnit outgoingTimeUnit, @Nonnull FieldSpec.DataType outgoingDataType, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingName, incomingDataType, incomingTimeUnitSize, incomingTimeUnit, outgoingName, outgoingDataType, outgoingTimeUnitSize, outgoingTimeUnit, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull TimeGranularitySpec incomingTimeGranularitySpec) {
            this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull TimeGranularitySpec incomingTimeGranularitySpec, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec, defaultNullValue));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull TimeGranularitySpec incomingTimeGranularitySpec, @Nonnull TimeGranularitySpec outgoingTimeGranularitySpec) {
            this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec, outgoingTimeGranularitySpec));
            return this;
        }

        public SchemaBuilder addTime(@Nonnull TimeGranularitySpec incomingTimeGranularitySpec, @Nonnull TimeGranularitySpec outgoingTimeGranularitySpec, @Nonnull Object defaultNullValue) {
            this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec, outgoingTimeGranularitySpec, defaultNullValue));
            return this;
        }

        public SchemaBuilder addDateTime(@Nonnull String name, @Nonnull FieldSpec.DataType dataType, @Nonnull String format, @Nonnull String granularity) {
            this._schema.addField(new DateTimeFieldSpec(name, dataType, format, granularity));
            return this;
        }

        public Schema build() {
            if (!this._schema.validate(LOGGER)) {
                throw new RuntimeException("Invalid schema");
            }
            return this._schema;
        }
    }
}

