/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.collect.Sets;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.segment.StarTreeMetadata;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StarTreeIndexSpec {
    public static final int DEFAULT_MAX_LEAF_RECORDS = 100000;
    public static final int DEFAULT_SKIP_MATERIALIZATION_CARDINALITY_THRESHOLD = 10000;
    @ConfigKey(value="maxLeafRecords")
    private int _maxLeafRecords = 100000;
    @ConfigKey(value="dimensionsSplitOrder")
    private List<String> _dimensionsSplitOrder;
    @ConfigKey(value="skipStarNodeCreationForDimensions")
    private Set<String> _skipStarNodeCreationForDimensions;
    @ConfigKey(value="skipMaterializationForDimensions")
    private Set<String> _skipMaterializationForDimensions;
    @ConfigKey(value="skipMaterializationCardinalityThreshold")
    private int _skipMaterializationCardinalityThreshold = 10000;
    @ConfigKey(value="excludeSkipMaterializationDimensionsForStarTreeIndex")
    private boolean _excludeSkipMaterializationDimensionsForStarTreeIndex;

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public void setMaxLeafRecords(int maxLeafRecords) {
        this._maxLeafRecords = maxLeafRecords;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public void setDimensionsSplitOrder(List<String> dimensionsSplitOrder) {
        this._dimensionsSplitOrder = dimensionsSplitOrder;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public void setSkipStarNodeCreationForDimensions(Set<String> skipStarNodeCreationForDimensions) {
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
    }

    public Set<String> getSkipMaterializationForDimensions() {
        return this._skipMaterializationForDimensions;
    }

    public void setSkipMaterializationForDimensions(Set<String> skipMaterializationForDimensions) {
        this._skipMaterializationForDimensions = skipMaterializationForDimensions;
    }

    public int getSkipMaterializationCardinalityThreshold() {
        return this._skipMaterializationCardinalityThreshold;
    }

    public void setSkipMaterializationCardinalityThreshold(int skipMaterializationCardinalityThreshold) {
        this._skipMaterializationCardinalityThreshold = skipMaterializationCardinalityThreshold;
    }

    public boolean isExcludeSkipMaterializationDimensionsForStarTreeIndex() {
        return this._excludeSkipMaterializationDimensionsForStarTreeIndex;
    }

    public void setExcludeSkipMaterializationDimensionsForStarTreeIndex(boolean excludeSkipMaterializationDimensionsForStarTreeIndex) {
        this._excludeSkipMaterializationDimensionsForStarTreeIndex = excludeSkipMaterializationDimensionsForStarTreeIndex;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toJsonString() throws JsonProcessingException {
        return JsonUtils.objectToString(this);
    }

    public static StarTreeIndexSpec fromFile(File starTreeIndexSpecFile) throws IOException {
        return JsonUtils.fileToObject(starTreeIndexSpecFile, StarTreeIndexSpec.class);
    }

    public static StarTreeIndexSpec fromJsonString(String jsonString) throws IOException {
        return JsonUtils.stringToObject(jsonString, StarTreeIndexSpec.class);
    }

    public static StarTreeIndexSpec fromStarTreeMetadata(StarTreeMetadata starTreeMetadata) {
        StarTreeIndexSpec starTreeIndexSpec = new StarTreeIndexSpec();
        starTreeIndexSpec.setMaxLeafRecords(starTreeMetadata.getMaxLeafRecords());
        starTreeIndexSpec.setDimensionsSplitOrder(starTreeMetadata.getDimensionsSplitOrder());
        starTreeIndexSpec.setSkipStarNodeCreationForDimensions(Sets.newHashSet(starTreeMetadata.getSkipStarNodeCreationForDimensions()));
        starTreeIndexSpec.setSkipMaterializationForDimensions(Sets.newHashSet(starTreeMetadata.getSkipMaterializationForDimensions()));
        starTreeIndexSpec.setSkipMaterializationCardinalityThreshold(starTreeMetadata.getSkipMaterializationCardinality());
        return starTreeIndexSpec;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        StarTreeIndexSpec that = (StarTreeIndexSpec)o;
        return EqualityUtils.isEqual(this._maxLeafRecords, that._maxLeafRecords) && EqualityUtils.isEqual(this._skipMaterializationCardinalityThreshold, that._skipMaterializationCardinalityThreshold) && EqualityUtils.isEqual(this._excludeSkipMaterializationDimensionsForStarTreeIndex, that._excludeSkipMaterializationDimensionsForStarTreeIndex) && EqualityUtils.isEqual(this._dimensionsSplitOrder, that._dimensionsSplitOrder) && EqualityUtils.isEqual(this._skipStarNodeCreationForDimensions, that._skipStarNodeCreationForDimensions) && EqualityUtils.isEqual(this._skipMaterializationForDimensions, that._skipMaterializationForDimensions);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._maxLeafRecords);
        result = EqualityUtils.hashCodeOf(result, this._dimensionsSplitOrder);
        result = EqualityUtils.hashCodeOf(result, this._skipStarNodeCreationForDimensions);
        result = EqualityUtils.hashCodeOf(result, this._skipMaterializationForDimensions);
        result = EqualityUtils.hashCodeOf(result, this._skipMaterializationCardinalityThreshold);
        result = EqualityUtils.hashCodeOf(result, this._excludeSkipMaterializationDimensionsForStarTreeIndex);
        return result;
    }
}

