/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.data.Schema;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.SchemaUtils;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKMetadataProvider.class);
    private static final String CLUSTER_TENANT_ISOLATION_ENABLED_KEY = "tenantIsolationEnabled";
    private static final String PROPERTYSTORE_SEGMENTS_PREFIX = "/SEGMENTS";
    private static final String PROPERTYSTORE_SCHEMAS_PREFIX = "/SCHEMAS";
    private static final String PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX = "/INSTANCE_PARTITIONS";
    private static final String PROPERTYSTORE_TABLE_CONFIGS_PREFIX = "/CONFIGS/TABLE";
    private static final String PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX = "/CONFIGS/INSTANCE";
    private static final String PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX = "/CONFIGS/CLUSTER";
    private static final String PROPERTYSTORE_SEGMENT_MERGE_LINEAGE = "/SEGMENT_MERGE_LINEAGE";

    private ZKMetadataProvider() {
    }

    public static void setRealtimeTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(realtimeTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setOfflineTableConfig(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName, ZNRecord znRecord) {
        propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(offlineTableName), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static void setInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, InstanceZKMetadata instanceZKMetadata) {
        ZNRecord znRecord = instanceZKMetadata.toZNRecord();
        propertyStore.set(StringUtil.join("/", PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceZKMetadata.getId()), (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static InstanceZKMetadata getInstanceZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, String instanceId) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(StringUtil.join("/", PROPERTYSTORE_INSTANCE_CONFIGS_PREFIX, instanceId), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        return new InstanceZKMetadata(znRecord);
    }

    public static String constructPropertyStorePathForSegment(String resourceName, String segmentName) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENTS_PREFIX, resourceName, segmentName);
    }

    public static String constructPropertyStorePathForSchema(String schemaName) {
        return StringUtil.join("/", PROPERTYSTORE_SCHEMAS_PREFIX, schemaName);
    }

    public static String constructPropertyStorePathForInstancePartitions(String offlineTableName) {
        return StringUtil.join("/", PROPERTYSTORE_INSTANCE_PARTITIONS_PREFIX, offlineTableName);
    }

    public static String constructPropertyStorePathForResource(String resourceName) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENTS_PREFIX, resourceName);
    }

    public static String constructPropertyStorePathForResourceConfig(String resourceName) {
        return StringUtil.join("/", PROPERTYSTORE_TABLE_CONFIGS_PREFIX, resourceName);
    }

    public static String constructPropertyStorePathForControllerConfig(String controllerConfigKey) {
        return StringUtil.join("/", PROPERTYSTORE_CLUSTER_CONFIGS_PREFIX, controllerConfigKey);
    }

    public static String constructPropertyStorePathForSegmentMergeLineage(String tableNameWithType) {
        return StringUtil.join("/", PROPERTYSTORE_SEGMENT_MERGE_LINEAGE, tableNameWithType);
    }

    public static boolean isSegmentExisted(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceNameForResource, String segmentName) {
        return propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForSegment(resourceNameForResource, segmentName), AccessOption.PERSISTENT);
    }

    public static void removeResourceSegmentsFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResource(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static void removeResourceConfigFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForResourceConfig(resourceName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static void removeInstancePartitionAssignmentFromPropertyStore(ZkHelixPropertyStore<ZNRecord> propertyStore, String offlineTableName) {
        String propertyStorePath = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(offlineTableName);
        if (propertyStore.exists(propertyStorePath, AccessOption.PERSISTENT)) {
            propertyStore.remove(propertyStorePath, AccessOption.PERSISTENT);
        }
    }

    public static boolean setOfflineSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, OfflineSegmentZKMetadata offlineSegmentZKMetadata, int expectedVersion) {
        try {
            return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(TableNameBuilder.OFFLINE.tableNameWithType(offlineSegmentZKMetadata.getTableName()), offlineSegmentZKMetadata.getSegmentName()), (Object)offlineSegmentZKMetadata.toZNRecord(), expectedVersion, AccessOption.PERSISTENT);
        }
        catch (ZkBadVersionException e) {
            return false;
        }
    }

    public static boolean setOfflineSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, OfflineSegmentZKMetadata offlineSegmentZKMetadata) {
        return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(TableNameBuilder.OFFLINE.tableNameWithType(offlineSegmentZKMetadata.getTableName()), offlineSegmentZKMetadata.getSegmentName()), (Object)offlineSegmentZKMetadata.toZNRecord(), AccessOption.PERSISTENT);
    }

    public static boolean setRealtimeSegmentZKMetadata(ZkHelixPropertyStore<ZNRecord> propertyStore, RealtimeSegmentZKMetadata realtimeSegmentZKMetadata) {
        return propertyStore.set(ZKMetadataProvider.constructPropertyStorePathForSegment(TableNameBuilder.REALTIME.tableNameWithType(realtimeSegmentZKMetadata.getTableName()), realtimeSegmentZKMetadata.getSegmentName()), (Object)realtimeSegmentZKMetadata.toZNRecord(), AccessOption.PERSISTENT);
    }

    @Nullable
    public static ZNRecord getZnRecord(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String path) {
        Stat stat = new Stat();
        ZNRecord znRecord = (ZNRecord)propertyStore.get(path, stat, AccessOption.PERSISTENT);
        if (znRecord != null) {
            znRecord.setCreationTime(stat.getCtime());
            znRecord.setModifiedTime(stat.getMtime());
            znRecord.setVersion(stat.getVersion());
        }
        return znRecord;
    }

    @Nullable
    public static OfflineSegmentZKMetadata getOfflineSegmentZKMetadata(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName, @Nonnull String segmentName) {
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment(offlineTableName, segmentName), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        return new OfflineSegmentZKMetadata(znRecord);
    }

    @Nullable
    public static RealtimeSegmentZKMetadata getRealtimeSegmentZKMetadata(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName, @Nonnull String segmentName) {
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment(realtimeTableName, segmentName), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        if (SegmentName.isHighLevelConsumerSegmentName(segmentName)) {
            return new RealtimeSegmentZKMetadata(znRecord);
        }
        return new LLCRealtimeSegmentZKMetadata(znRecord);
    }

    @Nullable
    public static TableConfig getTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableNameWithType) {
        ZNRecord znRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForResourceConfig(tableNameWithType), null, AccessOption.PERSISTENT);
        if (znRecord == null) {
            return null;
        }
        try {
            return TableConfig.fromZnRecord(znRecord);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting table configuration for table: {}", (Object)tableNameWithType, (Object)e);
            return null;
        }
    }

    @Nullable
    public static TableConfig getOfflineTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.OFFLINE.tableNameWithType(tableName));
    }

    @Nullable
    public static TableConfig getRealtimeTableConfig(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        return ZKMetadataProvider.getTableConfig(propertyStore, TableNameBuilder.REALTIME.tableNameWithType(tableName));
    }

    @Nullable
    public static Schema getSchema(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String schemaName) {
        try {
            ZNRecord schemaZNRecord = (ZNRecord)propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSchema(schemaName), null, AccessOption.PERSISTENT);
            if (schemaZNRecord == null) {
                return null;
            }
            return SchemaUtils.fromZNRecord(schemaZNRecord);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting schema: {}", (Object)schemaName, (Object)e);
            return null;
        }
    }

    @Nullable
    public static Schema getTableSchema(@Nonnull ZkHelixPropertyStore<ZNRecord> propertyStore, @Nonnull String tableName) {
        TableConfig realtimeTableConfig;
        String rawTableName = TableNameBuilder.extractRawTableName(tableName);
        Schema schema = ZKMetadataProvider.getSchema(propertyStore, rawTableName);
        if (schema != null) {
            return schema;
        }
        CommonConstants.Helix.TableType tableType = TableNameBuilder.getTableTypeFromTableName(tableName);
        if ((tableType == null || tableType == CommonConstants.Helix.TableType.REALTIME) && (realtimeTableConfig = ZKMetadataProvider.getRealtimeTableConfig(propertyStore, tableName)) != null) {
            schema = ZKMetadataProvider.getSchema(propertyStore, realtimeTableConfig.getValidationConfig().getSchemaName());
        }
        if (schema == null && (tableType == null || tableType == CommonConstants.Helix.TableType.OFFLINE)) {
            schema = ZKMetadataProvider.getSchema(propertyStore, TableNameBuilder.OFFLINE.tableNameWithType(tableName));
        }
        if (schema != null) {
            LOGGER.warn("Schema name does not match raw table name, schema name: {}, raw table name: {}", (Object)schema.getSchemaName(), (Object)TableNameBuilder.extractRawTableName(tableName));
        }
        return schema;
    }

    public static List<OfflineSegmentZKMetadata> getOfflineSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableName) {
        List znRecordList;
        ArrayList<OfflineSegmentZKMetadata> resultList = new ArrayList<OfflineSegmentZKMetadata>();
        if (propertyStore == null) {
            return resultList;
        }
        String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
        if (propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForResource(offlineTableName), AccessOption.PERSISTENT) && (znRecordList = propertyStore.getChildren(ZKMetadataProvider.constructPropertyStorePathForResource(offlineTableName), null, AccessOption.PERSISTENT)) != null) {
            for (ZNRecord record : znRecordList) {
                resultList.add(new OfflineSegmentZKMetadata(record));
            }
        }
        return resultList;
    }

    public static List<RealtimeSegmentZKMetadata> getRealtimeSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        List znRecordList;
        ArrayList<RealtimeSegmentZKMetadata> resultList = new ArrayList<RealtimeSegmentZKMetadata>();
        if (propertyStore == null) {
            return resultList;
        }
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(resourceName);
        if (propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName), AccessOption.PERSISTENT) && (znRecordList = propertyStore.getChildren(ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName), null, AccessOption.PERSISTENT)) != null) {
            for (ZNRecord record : znRecordList) {
                resultList.add(new RealtimeSegmentZKMetadata(record));
            }
        }
        return resultList;
    }

    public static List<LLCRealtimeSegmentZKMetadata> getLLCRealtimeSegmentZKMetadataListForTable(ZkHelixPropertyStore<ZNRecord> propertyStore, String resourceName) {
        List znRecordList;
        ArrayList<LLCRealtimeSegmentZKMetadata> resultList = new ArrayList<LLCRealtimeSegmentZKMetadata>();
        if (propertyStore == null) {
            return resultList;
        }
        String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(resourceName);
        if (propertyStore.exists(ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName), AccessOption.PERSISTENT) && (znRecordList = propertyStore.getChildren(ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName), null, AccessOption.PERSISTENT)) != null) {
            for (ZNRecord record : znRecordList) {
                RealtimeSegmentZKMetadata realtimeSegmentZKMetadata = new RealtimeSegmentZKMetadata(record);
                if (!SegmentName.isLowLevelConsumerSegmentName(realtimeSegmentZKMetadata.getSegmentName())) continue;
                resultList.add(new LLCRealtimeSegmentZKMetadata(record));
            }
        }
        return resultList;
    }

    public static List<String> getSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String tableNameWithType) {
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(tableNameWithType);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            return propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
        }
        return Collections.emptyList();
    }

    public static List<String> getLLCRealtimeSegments(ZkHelixPropertyStore<ZNRecord> propertyStore, String realtimeTableName) {
        ArrayList<String> llcRealtimeSegments = new ArrayList<String>();
        String segmentsPath = ZKMetadataProvider.constructPropertyStorePathForResource(realtimeTableName);
        if (propertyStore.exists(segmentsPath, AccessOption.PERSISTENT)) {
            List segments = propertyStore.getChildNames(segmentsPath, AccessOption.PERSISTENT);
            for (String segment : segments) {
                if (!SegmentName.isLowLevelConsumerSegmentName(segment)) continue;
                llcRealtimeSegments.add(segment);
            }
        }
        return llcRealtimeSegments;
    }

    public static void setClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore, boolean isSingleTenantCluster) {
        String path = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        ZNRecord znRecord = !propertyStore.exists(path, AccessOption.PERSISTENT) ? new ZNRecord(CLUSTER_TENANT_ISOLATION_ENABLED_KEY) : (ZNRecord)propertyStore.get(path, null, AccessOption.PERSISTENT);
        znRecord.setBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, isSingleTenantCluster);
        propertyStore.set(path, (Object)znRecord, AccessOption.PERSISTENT);
    }

    public static boolean getClusterTenantIsolationEnabled(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        String controllerConfigPath = ZKMetadataProvider.constructPropertyStorePathForControllerConfig(CLUSTER_TENANT_ISOLATION_ENABLED_KEY);
        if (propertyStore.exists(controllerConfigPath, AccessOption.PERSISTENT)) {
            ZNRecord znRecord = (ZNRecord)propertyStore.get(controllerConfigPath, null, AccessOption.PERSISTENT);
            if (znRecord.getSimpleFields().keySet().contains(CLUSTER_TENANT_ISOLATION_ENABLED_KEY)) {
                return znRecord.getBooleanField(CLUSTER_TENANT_ISOLATION_ENABLED_KEY, true);
            }
            return true;
        }
        return true;
    }
}

