/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import java.util.Map;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.utils.EqualityUtils;

public class LLCRealtimeSegmentZKMetadata
extends RealtimeSegmentZKMetadata {
    private static final String START_OFFSET = "segment.realtime.startOffset";
    private static final String END_OFFSET = "segment.realtime.endOffset";
    private static final String NUM_REPLICAS = "segment.realtime.numReplicas";
    public static final String DOWNLOAD_URL = "segment.realtime.download.url";
    private long _startOffset;
    private long _endOffset;
    private int _numReplicas;
    private String _downloadUrl = null;

    public LLCRealtimeSegmentZKMetadata() {
    }

    public LLCRealtimeSegmentZKMetadata(ZNRecord znRecord) {
        super(znRecord);
        this._startOffset = Long.valueOf(znRecord.getSimpleField(START_OFFSET));
        this._numReplicas = Integer.valueOf(znRecord.getSimpleField(NUM_REPLICAS));
        this._endOffset = Long.valueOf(znRecord.getSimpleField(END_OFFSET));
        this._downloadUrl = znRecord.getSimpleField(DOWNLOAD_URL);
    }

    public long getStartOffset() {
        return this._startOffset;
    }

    public long getEndOffset() {
        return this._endOffset;
    }

    public int getNumReplicas() {
        return this._numReplicas;
    }

    public void setStartOffset(long startOffset) {
        this._startOffset = startOffset;
    }

    public void setEndOffset(long endOffset) {
        this._endOffset = endOffset;
    }

    public void setNumReplicas(int numReplicas) {
        this._numReplicas = numReplicas;
    }

    public String getDownloadUrl() {
        return this._downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this._downloadUrl = downloadUrl;
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = super.toZNRecord();
        znRecord.setLongField(START_OFFSET, this._startOffset);
        znRecord.setLongField(END_OFFSET, this._endOffset);
        znRecord.setIntField(NUM_REPLICAS, this._numReplicas);
        znRecord.setSimpleField(DOWNLOAD_URL, this._downloadUrl);
        return znRecord;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String newline = "\n";
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newline);
        result.append("  " + super.getClass().getName() + " : " + super.toString());
        result.append(newline);
        result.append("  segment.realtime.startOffset : " + this._startOffset + ",");
        result.append(newline);
        result.append("  segment.realtime.download.url : " + this._downloadUrl + ",");
        result.append(newline);
        result.append("  segment.realtime.endOffset : " + this._endOffset);
        result.append(newline);
        result.append("}");
        return result.toString();
    }

    @Override
    public boolean equals(Object segmentMetadata) {
        if (EqualityUtils.isSameReference(this, segmentMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, segmentMetadata)) {
            return false;
        }
        LLCRealtimeSegmentZKMetadata metadata = (LLCRealtimeSegmentZKMetadata)segmentMetadata;
        return super.equals(metadata) && EqualityUtils.isEqual(this._startOffset, metadata._startOffset) && EqualityUtils.isEqual(this._endOffset, metadata._endOffset) && EqualityUtils.isEqual(this._downloadUrl, metadata._downloadUrl) && EqualityUtils.isEqual(this._numReplicas, metadata._numReplicas);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = EqualityUtils.hashCodeOf(result, this._startOffset);
        result = EqualityUtils.hashCodeOf(result, this._endOffset);
        result = EqualityUtils.hashCodeOf(result, this._numReplicas);
        result = EqualityUtils.hashCodeOf(result, this._downloadUrl);
        return result;
    }

    @Override
    public Map<String, String> toMap() {
        Map<String, String> configMap = super.toMap();
        configMap.put(START_OFFSET, Long.toString(this._startOffset));
        configMap.put(END_OFFSET, Long.toString(this._endOffset));
        configMap.put(NUM_REPLICAS, Integer.toString(this._numReplicas));
        configMap.put(DOWNLOAD_URL, this._downloadUrl);
        return configMap;
    }
}

