/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metadata.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.helix.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SegmentZKMetadata
implements ZKMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentZKMetadata.class);
    protected static final String NULL = "null";
    private String _segmentName;
    private String _tableName;
    private CommonConstants.Segment.SegmentType _segmentType;
    private long _startTime = -1L;
    private long _endTime = -1L;
    private TimeUnit _timeUnit;
    private Duration _timeGranularity;
    private Interval _timeInterval;
    private String _indexVersion;
    private long _totalRawDocs = -1L;
    private long _crc = -1L;
    private long _creationTime = -1L;
    private SegmentPartitionMetadata _partitionMetadata;
    private long _segmentUploadStartTime = -1L;
    private Map<String, String> _customMap;
    private String _crypterName;

    public SegmentZKMetadata() {
    }

    public SegmentZKMetadata(ZNRecord znRecord) {
        this._segmentName = znRecord.getSimpleField("segment.name");
        this._tableName = znRecord.getSimpleField("segment.table.name");
        this._crypterName = znRecord.getSimpleField("segment.crypter");
        this._segmentType = (CommonConstants.Segment.SegmentType)znRecord.getEnumField("segment.type", CommonConstants.Segment.SegmentType.class, (Enum)CommonConstants.Segment.SegmentType.OFFLINE);
        this._startTime = znRecord.getLongField("segment.start.time", -1L);
        this._endTime = znRecord.getLongField("segment.end.time", -1L);
        if (znRecord.getSimpleFields().containsKey("segment.time.unit") && !znRecord.getSimpleField("segment.time.unit").equals(NULL)) {
            this.setTimeUnit((TimeUnit)znRecord.getEnumField("segment.time.unit", TimeUnit.class, (Enum)TimeUnit.DAYS));
        }
        this._indexVersion = znRecord.getSimpleField("segment.index.version");
        this._totalRawDocs = znRecord.getLongField("segment.total.docs", -1L);
        this._crc = znRecord.getLongField("segment.crc", -1L);
        this._creationTime = znRecord.getLongField("segment.creation.time", -1L);
        try {
            String partitionMetadataJson = znRecord.getSimpleField("segment.partition.metadata");
            if (partitionMetadataJson != null) {
                this._partitionMetadata = SegmentPartitionMetadata.fromJsonString(partitionMetadataJson);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while reading partition info from zk metadata for segment '{}', partition info dropped.", (Object)this._segmentName, (Object)e);
        }
        this._segmentUploadStartTime = znRecord.getLongField("segment.upload.start.time", -1L);
        this._customMap = znRecord.getMapField("custom.map");
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public void setSegmentName(String segmentName) {
        this._segmentName = segmentName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public void setStartTime(long startTime) {
        this._startTime = startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public void setEndTime(long endTime) {
        this._endTime = endTime;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public void setTimeUnit(@Nonnull TimeUnit timeUnit) {
        this._timeUnit = timeUnit;
        this._timeGranularity = new Duration(this._timeUnit.toMillis(1L));
        if (this._startTime >= 0L && this._startTime <= this._endTime) {
            this._timeInterval = new Interval(this._timeUnit.toMillis(this._startTime), this._timeUnit.toMillis(this._endTime));
        }
    }

    public Duration getTimeGranularity() {
        return this._timeGranularity;
    }

    public Interval getTimeInterval() {
        return this._timeInterval;
    }

    public String getIndexVersion() {
        return this._indexVersion;
    }

    public void setIndexVersion(String indexVersion) {
        this._indexVersion = indexVersion;
    }

    public CommonConstants.Segment.SegmentType getSegmentType() {
        return this._segmentType;
    }

    public void setSegmentType(CommonConstants.Segment.SegmentType segmentType) {
        this._segmentType = segmentType;
    }

    public String getCrypterName() {
        return this._crypterName;
    }

    public void setCrypterName(String crypterName) {
        this._crypterName = crypterName;
    }

    public long getTotalRawDocs() {
        return this._totalRawDocs;
    }

    public void setTotalRawDocs(long totalRawDocs) {
        this._totalRawDocs = totalRawDocs;
    }

    public long getCrc() {
        return this._crc;
    }

    public void setCrc(long crc) {
        this._crc = crc;
    }

    public long getCreationTime() {
        return this._creationTime;
    }

    public void setCreationTime(long creationTime) {
        this._creationTime = creationTime;
    }

    public void setPartitionMetadata(SegmentPartitionMetadata partitionMetadata) {
        this._partitionMetadata = partitionMetadata;
    }

    public SegmentPartitionMetadata getPartitionMetadata() {
        return this._partitionMetadata;
    }

    public long getSegmentUploadStartTime() {
        return this._segmentUploadStartTime;
    }

    public void setSegmentUploadStartTime(long segmentUploadStartTime) {
        this._segmentUploadStartTime = segmentUploadStartTime;
    }

    public Map<String, String> getCustomMap() {
        return this._customMap;
    }

    public void setCustomMap(Map<String, String> customMap) {
        this._customMap = customMap;
    }

    public boolean equals(Object segmentMetadata) {
        if (EqualityUtils.isSameReference(this, segmentMetadata)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, segmentMetadata)) {
            return false;
        }
        SegmentZKMetadata metadata = (SegmentZKMetadata)segmentMetadata;
        return EqualityUtils.isEqual(this._segmentName, metadata._segmentName) && EqualityUtils.isEqual(this._crypterName, metadata._crypterName) && EqualityUtils.isEqual(this._tableName, metadata._tableName) && EqualityUtils.isEqual(this._indexVersion, metadata._indexVersion) && EqualityUtils.isEqual((Object)this._timeUnit, (Object)metadata._timeUnit) && EqualityUtils.isEqual(this._startTime, metadata._startTime) && EqualityUtils.isEqual(this._endTime, metadata._endTime) && EqualityUtils.isEqual((Object)this._segmentType, (Object)metadata._segmentType) && EqualityUtils.isEqual(this._totalRawDocs, metadata._totalRawDocs) && EqualityUtils.isEqual(this._crc, metadata._crc) && EqualityUtils.isEqual(this._creationTime, metadata._creationTime) && EqualityUtils.isEqual(this._partitionMetadata, metadata._partitionMetadata) && EqualityUtils.isEqual(this._segmentUploadStartTime, metadata._segmentUploadStartTime) && EqualityUtils.isEqual(this._customMap, metadata._customMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._segmentName);
        result = EqualityUtils.hashCodeOf(result, this._tableName);
        result = EqualityUtils.hashCodeOf(result, this._crypterName);
        result = EqualityUtils.hashCodeOf(result, (Object)this._segmentType);
        result = EqualityUtils.hashCodeOf(result, this._startTime);
        result = EqualityUtils.hashCodeOf(result, this._endTime);
        result = EqualityUtils.hashCodeOf(result, (Object)this._timeUnit);
        result = EqualityUtils.hashCodeOf(result, this._indexVersion);
        result = EqualityUtils.hashCodeOf(result, this._totalRawDocs);
        result = EqualityUtils.hashCodeOf(result, this._crc);
        result = EqualityUtils.hashCodeOf(result, this._creationTime);
        result = EqualityUtils.hashCodeOf(result, this._partitionMetadata);
        result = EqualityUtils.hashCodeOf(result, this._segmentUploadStartTime);
        result = EqualityUtils.hashCodeOf(result, this._customMap);
        return result;
    }

    @Override
    public ZNRecord toZNRecord() {
        ZNRecord znRecord = new ZNRecord(this._segmentName);
        znRecord.setSimpleField("segment.name", this._segmentName);
        znRecord.setSimpleField("segment.table.name", this._tableName);
        if (this._crypterName != null) {
            znRecord.setSimpleField("segment.crypter", this._crypterName);
        }
        znRecord.setEnumField("segment.type", (Enum)this._segmentType);
        if (this._timeUnit == null) {
            znRecord.setSimpleField("segment.time.unit", NULL);
        } else {
            znRecord.setEnumField("segment.time.unit", (Enum)this._timeUnit);
        }
        znRecord.setLongField("segment.start.time", this._startTime);
        znRecord.setLongField("segment.end.time", this._endTime);
        znRecord.setSimpleField("segment.index.version", this._indexVersion);
        znRecord.setLongField("segment.total.docs", this._totalRawDocs);
        znRecord.setLongField("segment.crc", this._crc);
        znRecord.setLongField("segment.creation.time", this._creationTime);
        if (this._partitionMetadata != null) {
            try {
                String partitionMetadataJson = this._partitionMetadata.toJsonString();
                znRecord.setSimpleField("segment.partition.metadata", partitionMetadataJson);
            }
            catch (IOException e) {
                LOGGER.error("Exception caught while writing partition metadata into ZNRecord for segment '{}', will be dropped", (Object)this._segmentName, (Object)e);
            }
        }
        if (this._segmentUploadStartTime > 0L) {
            znRecord.setLongField("segment.upload.start.time", this._segmentUploadStartTime);
        }
        if (this._customMap != null) {
            znRecord.setMapField("custom.map", this._customMap);
        }
        return znRecord;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("segment.name", this._segmentName);
        configMap.put("segment.table.name", this._tableName);
        configMap.put("segment.type", this._segmentType.toString());
        if (this._timeUnit == null) {
            configMap.put("segment.time.unit", null);
        } else {
            configMap.put("segment.time.unit", this._timeUnit.toString());
        }
        configMap.put("segment.start.time", Long.toString(this._startTime));
        configMap.put("segment.end.time", Long.toString(this._endTime));
        configMap.put("segment.index.version", this._indexVersion);
        configMap.put("segment.total.docs", Long.toString(this._totalRawDocs));
        configMap.put("segment.crc", Long.toString(this._crc));
        configMap.put("segment.creation.time", Long.toString(this._creationTime));
        if (this._partitionMetadata != null) {
            try {
                String partitionMetadataJson = this._partitionMetadata.toJsonString();
                configMap.put("segment.partition.metadata", partitionMetadataJson);
            }
            catch (IOException e) {
                LOGGER.error("Exception caught while converting partition metadata into JSON string for segment '{}', will be dropped", (Object)this._segmentName, (Object)e);
            }
        }
        if (this._segmentUploadStartTime > 0L) {
            configMap.put("segment.upload.start.time", Long.toString(this._segmentUploadStartTime));
        }
        if (this._customMap == null) {
            configMap.put("custom.map", null);
        } else {
            try {
                configMap.put("custom.map", JsonUtils.objectToString(this._customMap));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return configMap;
    }
}

