/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricName;
import org.apache.pinot.$internal.com.yammer.metrics.core.MetricsRegistry;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.apache.pinot.common.request.BrokerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetrics<QP extends QueryPhase, M extends Meter, G extends Gauge, T extends Timer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetrics.class);
    protected final String _metricPrefix;
    protected final MetricsRegistry _metricsRegistry;
    private final Class _clazz;
    private final Map<String, AtomicLong> _gaugeValues = new ConcurrentHashMap<String, AtomicLong>();
    protected final boolean _global;

    public AbstractMetrics(String metricPrefix, MetricsRegistry metricsRegistry, Class clazz) {
        this(metricPrefix, metricsRegistry, clazz, false);
    }

    public AbstractMetrics(String metricPrefix, MetricsRegistry metricsRegistry, Class clazz, boolean global) {
        this._metricPrefix = metricPrefix;
        this._metricsRegistry = metricsRegistry;
        this._clazz = clazz;
        this._global = global;
    }

    public void addPhaseTiming(BrokerRequest request, QP phase, long duration, TimeUnit timeUnit) {
        String fullTimerName = this.buildMetricName(request, phase.getQueryPhaseName());
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addPhaseTiming(BrokerRequest request, QP phase, long nanos) {
        this.addPhaseTiming(request, phase, nanos, TimeUnit.NANOSECONDS);
    }

    public void addPhaseTiming(String tableName, QP phase, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + phase.getQueryPhaseName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addPhaseTiming(String tableName, QP phase, long nanos) {
        this.addPhaseTiming(tableName, phase, nanos, TimeUnit.NANOSECONDS);
    }

    public void addTimedTableValue(String tableName, T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + this.getTableName(tableName) + "." + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    public void addTimedValue(T timer, long duration, TimeUnit timeUnit) {
        String fullTimerName = this._metricPrefix + timer.getTimerName();
        this.addValueToTimer(fullTimerName, duration, timeUnit);
    }

    private void addValueToTimer(String fullTimerName, long duration, TimeUnit timeUnit) {
        MetricName metricName = new MetricName(this._clazz, fullTimerName);
        org.apache.pinot.$internal.com.yammer.metrics.core.Timer timer = MetricsHelper.newTimer(this._metricsRegistry, metricName, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        MetricsHelper.newTimer(this._metricsRegistry, metricName, TimeUnit.MILLISECONDS, TimeUnit.SECONDS).update(duration, timeUnit);
    }

    private String buildMetricName(@Nullable BrokerRequest request, String metricName) {
        if (request != null && request.getQuerySource() != null && request.getQuerySource().getTableName() != null) {
            return this._metricPrefix + this.getTableName(request.getQuerySource().getTableName()) + "." + metricName;
        }
        return this._metricPrefix + "unknown." + metricName;
    }

    public <T> T timeQueryPhase(BrokerRequest request, QP phase, Callable<T> callable) throws Exception {
        long startTime = System.nanoTime();
        T returnValue = callable.call();
        long totalNanos = System.nanoTime() - startTime;
        this.addPhaseTiming(request, phase, totalNanos);
        LOGGER.debug(" Phase: {} took {}ms", phase, (Object)TimeUnit.MILLISECONDS.convert(totalNanos, TimeUnit.NANOSECONDS));
        return returnValue;
    }

    public void addMeteredGlobalValue(M meter, long unitCount) {
        this.addMeteredGlobalValue(meter, unitCount, null);
    }

    public org.apache.pinot.$internal.com.yammer.metrics.core.Meter addMeteredGlobalValue(M meter, long unitCount, org.apache.pinot.$internal.com.yammer.metrics.core.Meter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + meterName;
        MetricName metricName = new MetricName(this._clazz, fullMeterName);
        org.apache.pinot.$internal.com.yammer.metrics.core.Meter newMeter = MetricsHelper.newMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public void addMeteredTableValue(String tableName, M meter, long unitCount) {
        this.addMeteredTableValue(tableName, meter, unitCount, null);
    }

    public org.apache.pinot.$internal.com.yammer.metrics.core.Meter addMeteredTableValue(String tableName, M meter, long unitCount, org.apache.pinot.$internal.com.yammer.metrics.core.Meter reusedMeter) {
        if (reusedMeter != null) {
            reusedMeter.mark(unitCount);
            return reusedMeter;
        }
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + this.getTableName(tableName) + "." + meterName;
        MetricName metricName = new MetricName(this._clazz, fullMeterName);
        org.apache.pinot.$internal.com.yammer.metrics.core.Meter newMeter = MetricsHelper.newMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
        newMeter.mark(unitCount);
        return newMeter;
    }

    public org.apache.pinot.$internal.com.yammer.metrics.core.Meter getMeteredTableValue(String tableName, M meter) {
        String meterName = meter.getMeterName();
        String fullMeterName = this._metricPrefix + this.getTableName(tableName) + "." + meterName;
        MetricName metricName = new MetricName(this._clazz, fullMeterName);
        return MetricsHelper.newMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS);
    }

    public void addMeteredQueryValue(BrokerRequest request, M meter, long unitCount) {
        String meterName = meter.getMeterName();
        String fullMeterName = request != null ? this.buildMetricName(request, meterName) : this._metricPrefix + meterName;
        MetricName metricName = new MetricName(this._clazz, fullMeterName);
        MetricsHelper.newMeter(this._metricsRegistry, metricName, meter.getUnit(), TimeUnit.SECONDS).mark(unitCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueToTableGauge(String tableName, G gauge, long unitCount) {
        String gaugeName = gauge.getGaugeName();
        final String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(fullGaugeName)) {
                    this._gaugeValues.put(fullGaugeName, new AtomicLong(unitCount));
                    this.addCallbackGauge(fullGaugeName, new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return ((AtomicLong)AbstractMetrics.this._gaugeValues.get(fullGaugeName)).get();
                        }
                    });
                } else {
                    this._gaugeValues.get(fullGaugeName).addAndGet(unitCount);
                }
            }
        } else {
            this._gaugeValues.get(fullGaugeName).addAndGet(unitCount);
        }
    }

    public void setValueOfTableGauge(String tableName, G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, String suffix, long value) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + suffix;
        this.setValueOfGauge(value, fullGaugeName);
    }

    public void setValueOfGlobalGauge(G gauge, long value) {
        String gaugeName = gauge.getGaugeName();
        this.setValueOfGauge(value, gaugeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValueOfGauge(long value, String gaugeName) {
        if (!this._gaugeValues.containsKey(gaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(value));
                    this.addCallbackGauge(gaugeName, () -> this._gaugeValues.get(gaugeName).get());
                } else {
                    this._gaugeValues.get(gaugeName).set(value);
                }
            }
        } else {
            this._gaugeValues.get(gaugeName).set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueToGlobalGauge(G gauge, long unitCount) {
        final String gaugeName = gauge.getGaugeName();
        if (!this._gaugeValues.containsKey(gaugeName)) {
            Map<String, AtomicLong> map = this._gaugeValues;
            synchronized (map) {
                if (!this._gaugeValues.containsKey(gaugeName)) {
                    this._gaugeValues.put(gaugeName, new AtomicLong(unitCount));
                    this.addCallbackGauge(gaugeName, new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            return ((AtomicLong)AbstractMetrics.this._gaugeValues.get(gaugeName)).get();
                        }
                    });
                } else {
                    this._gaugeValues.get(gaugeName).addAndGet(unitCount);
                }
            }
        } else {
            this._gaugeValues.get(gaugeName).addAndGet(unitCount);
        }
    }

    @.VisibleForTesting
    public long getValueOfGlobalGauge(G gauge) {
        String gaugeName = gauge.getGaugeName();
        if (!this._gaugeValues.containsKey(gaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(gaugeName).get();
    }

    @.VisibleForTesting
    public long getValueOfGlobalGauge(G gauge, String suffix) {
        String fullGaugeName = gauge.getGaugeName() + "." + suffix;
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(fullGaugeName).get();
    }

    public long getValueOfTableGauge(String tableName, G gauge) {
        String gaugeName = gauge.getGaugeName();
        String fullGaugeName = gaugeName + "." + this.getTableName(tableName);
        if (!this._gaugeValues.containsKey(fullGaugeName)) {
            return 0L;
        }
        return this._gaugeValues.get(fullGaugeName).get();
    }

    public void initializeGlobalMeters() {
        Gauge[] gauges;
        Meter[] meters;
        for (Meter meter : meters = this.getMeters()) {
            if (!meter.isGlobal()) continue;
            this.addMeteredGlobalValue(meter, 0L);
        }
        for (Gauge gauge : gauges = this.getGauges()) {
            if (!gauge.isGlobal()) continue;
            this.setValueOfGlobalGauge(gauge, 0L);
        }
    }

    public void addCallbackGauge(String metricName, final Callable<Long> valueCallback) {
        MetricsHelper.newGauge(this._metricsRegistry, new MetricName(this._clazz, this._metricPrefix + metricName), new org.apache.pinot.$internal.com.yammer.metrics.core.Gauge<Long>(){

            @Override
            public Long value() {
                try {
                    return (Long)valueCallback.call();
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception", (Throwable)e);
                    Utils.rethrowException(e);
                    throw new AssertionError((Object)"Should not reach this");
                }
            }
        });
    }

    protected abstract QP[] getQueryPhases();

    protected abstract M[] getMeters();

    protected abstract G[] getGauges();

    protected String getTableName(String tableName) {
        return this._global ? "allTables" : tableName;
    }

    public static interface Timer {
        public String getTimerName();

        public boolean isGlobal();
    }

    public static interface Gauge {
        public String getGaugeName();

        public String getUnit();

        public boolean isGlobal();
    }

    public static interface Meter {
        public String getMeterName();

        public String getUnit();

        public boolean isGlobal();
    }

    public static interface QueryPhase {
        public String getQueryPhaseName();
    }
}

