/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.partition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.pinot.common.partition.PartitionAssignment;

public class ReplicaGroupPartitionAssignment
extends PartitionAssignment {
    private static final String SEPARATOR = "_";

    public ReplicaGroupPartitionAssignment(String tableName) {
        super(tableName);
    }

    public ReplicaGroupPartitionAssignment(String tableName, Map<String, List<String>> partitionToInstances) {
        super(tableName, partitionToInstances);
    }

    @Override
    public int getNumPartitions() {
        HashSet<String> partitions = new HashSet<String>();
        for (String key : this.getPartitionToInstances().keySet()) {
            String partitionId = key.split(SEPARATOR)[0];
            partitions.add(partitionId);
        }
        return partitions.size();
    }

    public int getNumReplicaGroups() {
        HashSet<String> replicaGroups = new HashSet<String>();
        for (String key : this.getPartitionToInstances().keySet()) {
            String replicaGroupId = key.split(SEPARATOR)[1];
            replicaGroups.add(replicaGroupId);
        }
        return replicaGroups.size();
    }

    public void addInstanceToReplicaGroup(int partition, int replicaGroup, String instanceName) {
        String key = this.createMappingKey(partition, replicaGroup);
        if (!this.getPartitionToInstances().containsKey(key)) {
            this.addPartition(key, new ArrayList<String>());
        }
        this.getInstancesListForPartition(key).add(instanceName);
    }

    public List<String> getInstancesfromReplicaGroup(int partition, int replicaGroup) {
        String key = this.createMappingKey(partition, replicaGroup);
        if (!this.getPartitionToInstances().containsKey(key)) {
            throw new NoSuchElementException();
        }
        return this.getInstancesListForPartition(key);
    }

    public void setInstancesToReplicaGroup(int partition, int replicaGroup, List<String> instances) {
        String key = this.createMappingKey(partition, replicaGroup);
        this.addPartition(key, instances);
    }

    private String createMappingKey(int partition, int replicaGroup) {
        return partition + SEPARATOR + replicaGroup;
    }
}

