/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.partition;

import java.util.Collections;
import java.util.List;
import org.apache.helix.AccessOption;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.common.config.ReplicaGroupStrategyConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.partition.ReplicaGroupPartitionAssignment;

public class ReplicaGroupPartitionAssignmentGenerator {
    private ZkHelixPropertyStore<ZNRecord> _propertyStore;

    public ReplicaGroupPartitionAssignmentGenerator(ZkHelixPropertyStore<ZNRecord> propertyStore) {
        this._propertyStore = propertyStore;
    }

    public ReplicaGroupPartitionAssignment getReplicaGroupPartitionAssignment(String tableNameWithType) {
        String path = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(tableNameWithType);
        ZNRecord replicaGroupPartitionAssignment = (ZNRecord)this._propertyStore.get(path, null, AccessOption.PERSISTENT);
        ReplicaGroupPartitionAssignment partitionAssignment = null;
        if (replicaGroupPartitionAssignment != null) {
            partitionAssignment = new ReplicaGroupPartitionAssignment(tableNameWithType, replicaGroupPartitionAssignment.getListFields());
        }
        return partitionAssignment;
    }

    public void writeReplicaGroupPartitionAssignment(ReplicaGroupPartitionAssignment partitionAssignment) {
        String tableNameWithType = partitionAssignment.getTableName();
        ZNRecord znRecord = new ZNRecord(tableNameWithType);
        znRecord.setListFields(partitionAssignment.getPartitionToInstances());
        String path = ZKMetadataProvider.constructPropertyStorePathForInstancePartitions(tableNameWithType);
        this._propertyStore.set(path, (Object)znRecord, AccessOption.PERSISTENT);
    }

    public ReplicaGroupPartitionAssignment buildReplicaGroupPartitionAssignment(String tableNameWithType, TableConfig tableConfig, List<String> servers) {
        int numServers;
        int numReplicas;
        ReplicaGroupStrategyConfig replicaGroupStrategyConfig = tableConfig.getValidationConfig().getReplicaGroupStrategyConfig();
        Preconditions.checkNotNull(replicaGroupStrategyConfig, "Replica group strategy config should not be null");
        String partitionColumn = replicaGroupStrategyConfig.getPartitionColumn();
        int numInstancesPerPartition = replicaGroupStrategyConfig.getNumInstancesPerPartition();
        int numColumnPartitions = 1;
        if (partitionColumn != null) {
            numColumnPartitions = tableConfig.getIndexingConfig().getSegmentPartitionConfig().getNumPartitions(partitionColumn);
        }
        if (numInstancesPerPartition * (numReplicas = tableConfig.getValidationConfig().getReplicationNumber()) > (numServers = servers.size())) {
            throw new UnsupportedOperationException("Replica group aware segment assignment assumes that servers in each replica group are disjoint. Check the configurations to see if the following inequality holds. 'numInstancePerPartition' * 'numReplicas' <= 'totalServerNumbers'");
        }
        ReplicaGroupPartitionAssignment partitionAssignment = new ReplicaGroupPartitionAssignment(tableNameWithType);
        Collections.sort(servers);
        for (int partitionId = 0; partitionId < numColumnPartitions; ++partitionId) {
            if (numColumnPartitions != 1) {
                Collections.shuffle(servers);
            }
            for (int i = 0; i < numInstancesPerPartition * numReplicas; ++i) {
                int groupId = i / numInstancesPerPartition;
                partitionAssignment.addInstanceToReplicaGroup(partitionId, groupId, servers.get(i));
            }
        }
        return partitionAssignment;
    }
}

