/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixManager;
import org.apache.helix.model.IdealState;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.collect.Lists;
import org.apache.pinot.common.config.RealtimeTagConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.partition.PartitionAssignment;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.helix.HelixHelper;

public class StreamPartitionAssignmentGenerator {
    private HelixManager _helixManager;

    public StreamPartitionAssignmentGenerator(HelixManager helixManager) {
        this._helixManager = helixManager;
    }

    public PartitionAssignment getStreamPartitionAssignmentFromIdealState(TableConfig tableConfig, IdealState idealState) {
        String tableNameWithType = tableConfig.getTableName();
        Map<String, LLCSegmentName> partitionIdToLatestSegment = this.getPartitionToLatestSegments(idealState);
        PartitionAssignment partitionAssignment = new PartitionAssignment(tableNameWithType);
        Map mapFields = idealState.getRecord().getMapFields();
        for (Map.Entry<String, LLCSegmentName> entry : partitionIdToLatestSegment.entrySet()) {
            String segmentName = entry.getValue().getSegmentName();
            Map instanceStateMap = (Map)mapFields.get(segmentName);
            partitionAssignment.addPartition(entry.getKey(), Lists.newArrayList(instanceStateMap.keySet()));
        }
        return partitionAssignment;
    }

    @.VisibleForTesting
    public Map<String, LLCSegmentName> getPartitionToLatestSegments(IdealState idealState) {
        HashMap<String, LLCSegmentName> partitionIdToLatestSegment = new HashMap<String, LLCSegmentName>();
        Map mapFields = idealState.getRecord().getMapFields();
        for (Map.Entry entry : mapFields.entrySet()) {
            LLCSegmentName llcSegmentName;
            String partitionId;
            LLCSegmentName latestSegment;
            String segmentName = (String)entry.getKey();
            if (!LLCSegmentName.isLowLevelConsumerSegmentName(segmentName) || (latestSegment = (LLCSegmentName)partitionIdToLatestSegment.get(partitionId = String.valueOf((llcSegmentName = new LLCSegmentName(segmentName)).getPartitionId()))) != null && llcSegmentName.getSequenceNumber() <= latestSegment.getSequenceNumber()) continue;
            partitionIdToLatestSegment.put(partitionId, llcSegmentName);
        }
        return partitionIdToLatestSegment;
    }

    public int getNumPartitionsFromIdealState(IdealState idealState) {
        HashSet<Integer> partitions = new HashSet<Integer>();
        Map mapFields = idealState.getRecord().getMapFields();
        for (Map.Entry entry : mapFields.entrySet()) {
            String segmentName = (String)entry.getKey();
            if (!LLCSegmentName.isLowLevelConsumerSegmentName(segmentName)) continue;
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            partitions.add(llcSegmentName.getPartitionId());
        }
        return partitions.size();
    }

    public PartitionAssignment generateStreamPartitionAssignment(TableConfig tableConfig, int numPartitions) throws InvalidConfigException {
        ArrayList<String> partitions = new ArrayList<String>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitions.add(String.valueOf(i));
        }
        String tableNameWithType = tableConfig.getTableName();
        int numReplicas = tableConfig.getValidationConfig().getReplicasPerPartitionNumber();
        List<String> consumingTaggedInstances = this.getConsumingTaggedInstances(tableConfig);
        if (consumingTaggedInstances.size() < numReplicas) {
            throw new InvalidConfigException("Not enough consuming instances tagged. Must be atleast equal to numReplicas:" + numReplicas);
        }
        return this.uniformAssignment(tableNameWithType, partitions, numReplicas, consumingTaggedInstances);
    }

    private PartitionAssignment uniformAssignment(String tableName, List<String> partitions, int numReplicas, List<String> allInstances) {
        PartitionAssignment partitionAssignment = new PartitionAssignment(tableName);
        Collections.sort(allInstances);
        int numInstances = allInstances.size();
        int serverId = Math.abs(EqualityUtils.hashCodeOf(tableName)) % numInstances;
        for (String partition : partitions) {
            ArrayList<String> instances = new ArrayList<String>(numReplicas);
            for (int r = 0; r < numReplicas; ++r) {
                instances.add(allInstances.get(serverId));
                serverId = (serverId + 1) % numInstances;
            }
            partitionAssignment.addPartition(partition, instances);
        }
        return partitionAssignment;
    }

    @.VisibleForTesting
    protected List<String> getConsumingTaggedInstances(TableConfig tableConfig) {
        RealtimeTagConfig realtimeTagConfig = new RealtimeTagConfig(tableConfig);
        String consumingServerTag = realtimeTagConfig.getConsumingServerTag();
        List<String> consumingTaggedInstances = HelixHelper.getInstancesWithTag(this._helixManager, consumingServerTag);
        if (consumingTaggedInstances.isEmpty()) {
            throw new IllegalStateException("No instances found with tag " + consumingServerTag);
        }
        return consumingTaggedInstances;
    }
}

