/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.common.response.BrokerResponse;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.response.broker.BrokerResponseNative;

public class BrokerResponseFactory {
    private static final String ILLEGAL_RESPONSE_TYPE = "Unsupported broker response type: ";

    private BrokerResponseFactory() {
    }

    @Nonnull
    public static ResponseType getResponseType(@Nullable String responseType) {
        if (responseType == null || responseType.equalsIgnoreCase(ResponseType.BROKER_RESPONSE_TYPE_NATIVE.name())) {
            return ResponseType.BROKER_RESPONSE_TYPE_NATIVE;
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + responseType);
    }

    @Nonnull
    public static BrokerResponse getBrokerResponse(@Nonnull ResponseType responseType) {
        if (responseType.equals((Object)ResponseType.BROKER_RESPONSE_TYPE_NATIVE)) {
            return new BrokerResponseNative();
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + (Object)((Object)responseType));
    }

    @Nonnull
    public static BrokerResponse getBrokerResponseWithException(@Nonnull ResponseType responseType, @Nonnull ProcessingException processingException) {
        if (responseType.equals((Object)ResponseType.BROKER_RESPONSE_TYPE_NATIVE)) {
            return new BrokerResponseNative(processingException);
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + (Object)((Object)responseType));
    }

    @Nonnull
    public static BrokerResponse getBrokerResponseWithExceptions(@Nonnull ResponseType responseType, @Nonnull List<ProcessingException> processingExceptions) {
        if (responseType.equals((Object)ResponseType.BROKER_RESPONSE_TYPE_NATIVE)) {
            return new BrokerResponseNative(processingExceptions);
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + (Object)((Object)responseType));
    }

    @Nonnull
    public static BrokerResponse getStaticNoTableHitBrokerResponse(@Nonnull ResponseType responseType) {
        if (responseType.equals((Object)ResponseType.BROKER_RESPONSE_TYPE_NATIVE)) {
            return BrokerResponseNative.NO_TABLE_RESULT;
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + (Object)((Object)responseType));
    }

    @Nonnull
    public static BrokerResponse getStaticEmptyBrokerResponse(@Nonnull ResponseType responseType) {
        if (responseType.equals((Object)ResponseType.BROKER_RESPONSE_TYPE_NATIVE)) {
            return BrokerResponseNative.EMPTY_RESULT;
        }
        throw new IllegalArgumentException(ILLEGAL_RESPONSE_TYPE + (Object)((Object)responseType));
    }

    public static enum ResponseType {
        BROKER_RESPONSE_TYPE_NATIVE;

    }
}

