/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.segment.fetcher;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.segment.fetcher.HttpSegmentFetcher;
import org.apache.pinot.common.segment.fetcher.HttpsSegmentFetcher;
import org.apache.pinot.common.segment.fetcher.PinotFSSegmentFetcher;
import org.apache.pinot.common.segment.fetcher.SegmentFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFetcherFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentFetcherFactory.class);
    private static final SegmentFetcherFactory INSTANCE = new SegmentFetcherFactory();
    public static final String PROTOCOLS_KEY = "protocols";
    public static final List<String> DEFAULT_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("file", "http"));
    public static final Map<String, String> DEFAULT_FETCHER_CLASS_MAP = Collections.unmodifiableMap(new HashMap<String, String>(5){
        {
            this.put("http", HttpSegmentFetcher.class.getName());
            this.put("https", HttpsSegmentFetcher.class.getName());
            this.put("hdfs", PinotFSSegmentFetcher.class.getName());
            this.put("adl", PinotFSSegmentFetcher.class.getName());
            this.put("file", PinotFSSegmentFetcher.class.getName());
        }
    });
    public static final String FETCHER_CLASS_KEY_SUFFIX = ".class";
    private final Map<String, SegmentFetcher> _segmentFetcherMap = new HashMap<String, SegmentFetcher>();

    private SegmentFetcherFactory() {
    }

    public static SegmentFetcherFactory getInstance() {
        return INSTANCE;
    }

    public void init(Configuration segmentFetcherClassConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        List protocols = segmentFetcherClassConfig.getList(PROTOCOLS_KEY, DEFAULT_PROTOCOLS);
        for (String protocol : protocols) {
            String fetcherClass = segmentFetcherClassConfig.getString(protocol + FETCHER_CLASS_KEY_SUFFIX, DEFAULT_FETCHER_CLASS_MAP.get(protocol));
            Preconditions.checkNotNull(fetcherClass, "No fetcher class defined for protocol: " + protocol);
            LOGGER.info("Creating a new segment fetcher for protocol: {} with class: {}", (Object)protocol, (Object)fetcherClass);
            SegmentFetcher segmentFetcher = (SegmentFetcher)Class.forName(fetcherClass).newInstance();
            LOGGER.info("Initializing segment fetcher for protocol: {}", (Object)protocol);
            Configuration segmentFetcherConfig = segmentFetcherClassConfig.subset(protocol);
            SegmentFetcherFactory.logFetcherInitConfig(segmentFetcher, protocol, segmentFetcherConfig);
            segmentFetcher.init(segmentFetcherConfig);
            this._segmentFetcherMap.put(protocol, segmentFetcher);
        }
    }

    public boolean containsProtocol(String protocol) {
        return this._segmentFetcherMap.containsKey(protocol);
    }

    public SegmentFetcher getSegmentFetcherBasedOnURI(String uri) throws URISyntaxException {
        String protocol = new URI(uri).getScheme();
        return this._segmentFetcherMap.get(protocol);
    }

    private static void logFetcherInitConfig(SegmentFetcher fetcher, String protocol, Configuration conf) {
        LOGGER.info("Initializing protocol [{}] with the following configs:", (Object)protocol);
        Iterator iter = conf.getKeys();
        Set<String> secretKeys = fetcher.getProtectedConfigKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (secretKeys.contains(key)) {
                LOGGER.info("{}: {}", (Object)key, (Object)"********");
                continue;
            }
            LOGGER.info("{}: {}", (Object)key, (Object)conf.getString(key));
        }
        LOGGER.info("");
    }
}

