/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.common.data.FieldSpec;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.StringUtil;

public class DataSchema {
    private String[] _columnNames;
    private ColumnDataType[] _columnDataTypes;

    public DataSchema(@Nonnull String[] columnNames, @Nonnull ColumnDataType[] columnDataTypes) {
        this._columnNames = columnNames;
        this._columnDataTypes = columnDataTypes;
    }

    public int size() {
        return this._columnNames.length;
    }

    @Nonnull
    public String getColumnName(int index) {
        return this._columnNames[index];
    }

    @Nonnull
    public ColumnDataType getColumnDataType(int index) {
        return this._columnDataTypes[index];
    }

    public boolean isTypeCompatibleWith(@Nonnull DataSchema anotherDataSchema) {
        if (!Arrays.equals(this._columnNames, anotherDataSchema._columnNames)) {
            return false;
        }
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            if (this._columnDataTypes[i].isCompatible(anotherDataSchema._columnDataTypes[i])) continue;
            return false;
        }
        return true;
    }

    public void upgradeToCover(@Nonnull DataSchema anotherDataSchema) {
        int numColumns = this._columnDataTypes.length;
        for (int i = 0; i < numColumns; ++i) {
            ColumnDataType thisColumnDataType = this._columnDataTypes[i];
            ColumnDataType thatColumnDataType = anotherDataSchema._columnDataTypes[i];
            if (thisColumnDataType == thatColumnDataType) continue;
            if (thisColumnDataType.isArray()) {
                if (thisColumnDataType.isWholeNumberArray() && thatColumnDataType.isWholeNumberArray()) {
                    this._columnDataTypes[i] = ColumnDataType.LONG_ARRAY;
                    continue;
                }
                this._columnDataTypes[i] = ColumnDataType.DOUBLE_ARRAY;
                continue;
            }
            this._columnDataTypes[i] = thisColumnDataType.isWholeNumber() && thatColumnDataType.isWholeNumber() ? ColumnDataType.LONG : ColumnDataType.DOUBLE;
        }
    }

    @Nonnull
    public byte[] toBytes() throws IOException {
        byte[] bytes;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int length = this._columnNames.length;
        dataOutputStream.writeInt(length);
        for (String string : this._columnNames) {
            bytes = StringUtil.encodeUtf8(string);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        for (ColumnDataType columnDataType : this._columnDataTypes) {
            bytes = StringUtil.encodeUtf8(columnDataType.name());
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Nonnull
    public static DataSchema fromBytes(@Nonnull byte[] buffer) throws IOException {
        int readLength;
        byte[] bytes;
        int length;
        int i;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int numColumns = dataInputStream.readInt();
        String[] columnNames = new String[numColumns];
        ColumnDataType[] columnDataTypes = new ColumnDataType[numColumns];
        for (i = 0; i < numColumns; ++i) {
            length = dataInputStream.readInt();
            bytes = new byte[length];
            readLength = dataInputStream.read(bytes);
            assert (readLength == length);
            columnNames[i] = StringUtil.decodeUtf8(bytes);
        }
        for (i = 0; i < numColumns; ++i) {
            length = dataInputStream.readInt();
            bytes = new byte[length];
            readLength = dataInputStream.read(bytes);
            assert (readLength == length);
            columnDataTypes[i] = ColumnDataType.valueOf(StringUtil.decodeUtf8(bytes));
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    public DataSchema clone() {
        return new DataSchema((String[])this._columnNames.clone(), (ColumnDataType[])this._columnDataTypes.clone());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int numColumns = this._columnNames.length;
        for (int i = 0; i < numColumns; ++i) {
            stringBuilder.append(this._columnNames[i]).append('(').append((Object)this._columnDataTypes[i]).append(')').append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
        return stringBuilder.toString();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof DataSchema) {
            DataSchema anotherDataSchema = (DataSchema)anObject;
            return Arrays.equals(this._columnNames, anotherDataSchema._columnNames) && Arrays.equals((Object[])this._columnDataTypes, (Object[])anotherDataSchema._columnDataTypes);
        }
        return false;
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf(Arrays.hashCode(this._columnNames), Arrays.hashCode((Object[])this._columnDataTypes));
    }

    public static enum ColumnDataType {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        BYTES,
        OBJECT,
        INT_ARRAY,
        LONG_ARRAY,
        FLOAT_ARRAY,
        DOUBLE_ARRAY,
        STRING_ARRAY;


        public boolean isNumber() {
            return this == INT || this == LONG || this == FLOAT || this == DOUBLE;
        }

        public boolean isWholeNumber() {
            return this == INT || this == LONG;
        }

        public boolean isArray() {
            return this == INT_ARRAY || this == LONG_ARRAY || this == FLOAT_ARRAY || this == DOUBLE_ARRAY || this == STRING_ARRAY;
        }

        public boolean isNumberArray() {
            return this == INT_ARRAY || this == LONG_ARRAY || this == FLOAT_ARRAY || this == DOUBLE_ARRAY;
        }

        public boolean isWholeNumberArray() {
            return this == INT_ARRAY || this == LONG_ARRAY;
        }

        public boolean isCompatible(ColumnDataType anotherColumnDataType) {
            return this == anotherColumnDataType || this.isNumber() && anotherColumnDataType.isNumber() || this.isNumberArray() && anotherColumnDataType.isNumberArray();
        }

        public static ColumnDataType fromDataType(FieldSpec.DataType dataType, boolean isSingleValue) {
            switch (dataType) {
                case INT: {
                    return isSingleValue ? INT : INT_ARRAY;
                }
                case LONG: {
                    return isSingleValue ? LONG : LONG_ARRAY;
                }
                case FLOAT: {
                    return isSingleValue ? FLOAT : FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return isSingleValue ? DOUBLE : DOUBLE_ARRAY;
                }
                case STRING: {
                    return isSingleValue ? STRING : STRING_ARRAY;
                }
                case BYTES: {
                    if (!isSingleValue) break;
                    return BYTES;
                }
            }
            throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)dataType));
        }
    }
}

