/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.pinot.;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.io.IOUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.JsonUtils;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadDownloadClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUploadDownloadClient.class);
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 600000;
    public static final int GET_REQUEST_SOCKET_TIMEOUT_MS = 5000;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SCHEMA_PATH = "/schemas";
    private static final String OLD_SEGMENT_PATH = "/segments";
    private static final String SEGMENT_PATH = "/v2/segments";
    private static final String SEGMENT_METADATA_PATH = "/segmentmetadata";
    private static final String TABLES_PATH = "/tables";
    private static final String TYPE_DELIMITER = "?type=";
    private final .CloseableHttpClient _httpClient;

    public FileUploadDownloadClient() {
        this(null);
    }

    public FileUploadDownloadClient(@Nullable SSLContext sslContext) {
        this._httpClient = .HttpClients.custom().setSSLContext(sslContext).build();
    }

    private static URI getURI(String scheme, String host, int port, String path) throws URISyntaxException {
        return new URI(scheme, null, host, port, path, null, null);
    }

    public static URI getRetrieveTableConfigHttpURI(String host, int port, String rawTableName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/tables/" + rawTableName);
    }

    public static URI getRetrieveSchemaHttpURI(String host, int port, String schemaName) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, "/schemas/" + schemaName);
    }

    public static URI getUploadSchemaHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SCHEMA_PATH);
    }

    public static URI getUploadSchemaHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SCHEMA_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, OLD_SEGMENT_PATH);
    }

    @Deprecated
    public static URI getOldUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, OLD_SEGMENT_PATH);
    }

    public static URI getUploadSegmentHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SEGMENT_PATH);
    }

    public static URI getUploadSegmentMetadataHttpURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTP, host, port, SEGMENT_METADATA_PATH);
    }

    public static URI getUploadSegmentMetadataHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SEGMENT_METADATA_PATH);
    }

    public static URI getUploadSegmentHttpsURI(String host, int port) throws URISyntaxException {
        return FileUploadDownloadClient.getURI(HTTPS, host, port, SEGMENT_PATH);
    }

    private static .HttpUriRequest getUploadFileRequest(String method, URI uri, .ContentBody contentBody, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        .HttpEntity entity = .MultipartEntityBuilder.create().setMode(.HttpMultipartMode.BROWSER_COMPATIBLE).addPart(contentBody.getFilename(), contentBody).build();
        .RequestBuilder requestBuilder = .RequestBuilder.create((String)method).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1).setUri(uri).setEntity(entity);
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static .HttpUriRequest constructGetRequest(URI uri) {
        .RequestBuilder requestBuilder = .RequestBuilder.get((URI)uri).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.setTimeout(requestBuilder, 5000);
        return requestBuilder.build();
    }

    private static .HttpUriRequest getAddSchemaRequest(URI uri, String schemaName, File schemaFile) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), null, null, 600000);
    }

    private static .HttpUriRequest getUpdateSchemaRequest(URI uri, String schemaName, File schemaFile) {
        return FileUploadDownloadClient.getUploadFileRequest("PUT", uri, FileUploadDownloadClient.getContentBody(schemaName, schemaFile), null, null, 600000);
    }

    private static .HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, File segmentFile, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static .HttpUriRequest getUploadSegmentRequest(URI uri, String segmentName, InputStream inputStream, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, inputStream), headers, parameters, socketTimeoutMs);
    }

    private static .HttpUriRequest getUploadSegmentMetadataRequest(URI uri, String segmentName, File segmentFile, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        return FileUploadDownloadClient.getUploadFileRequest("POST", uri, FileUploadDownloadClient.getContentBody(segmentName, segmentFile), headers, parameters, socketTimeoutMs);
    }

    private static .HttpUriRequest getSendSegmentUriRequest(URI uri, String downloadUri, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        .RequestBuilder requestBuilder = .RequestBuilder.post((URI)uri).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.URI.toString()).setHeader("DOWNLOAD_URI", downloadUri).setHeader("Content-Type", "application/json");
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static .HttpUriRequest getSendSegmentJsonRequest(URI uri, String jsonString, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) {
        .RequestBuilder requestBuilder = .RequestBuilder.post((URI)uri).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1).setHeader("UPLOAD_TYPE", FileUploadType.JSON.toString()).setEntity((.HttpEntity)new .StringEntity(jsonString, .ContentType.APPLICATION_JSON));
        FileUploadDownloadClient.addHeadersAndParameters(requestBuilder, headers, parameters);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static .HttpUriRequest getSegmentCompletionProtocolRequest(URI uri, int socketTimeoutMs) {
        .RequestBuilder requestBuilder = .RequestBuilder.get((URI)uri).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static .HttpUriRequest getDownloadFileRequest(URI uri, int socketTimeoutMs) {
        .RequestBuilder requestBuilder = .RequestBuilder.get((URI)uri).setVersion((.ProtocolVersion).HttpVersion.HTTP_1_1);
        FileUploadDownloadClient.setTimeout(requestBuilder, socketTimeoutMs);
        return requestBuilder.build();
    }

    private static .ContentBody getContentBody(String fileName, File file) {
        return new .FileBody(file, .ContentType.DEFAULT_BINARY, fileName);
    }

    private static .ContentBody getContentBody(String fileName, InputStream inputStream) {
        return new .InputStreamBody(inputStream, .ContentType.DEFAULT_BINARY, fileName);
    }

    private static void addHeadersAndParameters(.RequestBuilder requestBuilder, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters) {
        if (headers != null) {
            for (.Header header : headers) {
                requestBuilder.addHeader(header);
            }
        }
        if (parameters != null) {
            for (.NameValuePair parameter : parameters) {
                requestBuilder.addParameter(parameter);
            }
        }
    }

    private static void setTimeout(.RequestBuilder requestBuilder, int socketTimeoutMs) {
        .RequestConfig requestConfig = .RequestConfig.custom().setSocketTimeout(socketTimeoutMs).build();
        requestBuilder.setConfig(requestConfig);
    }

    private SimpleHttpResponse sendRequest(.HttpUriRequest request) throws IOException, HttpErrorStatusException {
        try (.CloseableHttpResponse response = this._httpClient.execute(request);){
            int statusCode;
            String controllerHost = null;
            String controllerVersion = null;
            if (response.containsHeader("Pinot-Controller-Host")) {
                controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
                controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
            }
            if (controllerHost != null) {
                LOGGER.info(String.format("Sending request: %s to controller: %s, version: %s", request.getURI(), controllerHost, controllerVersion));
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) >= 300) {
                throw new HttpErrorStatusException(FileUploadDownloadClient.getErrorMessage(request, response), statusCode);
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, .EntityUtils.toString((.HttpEntity)response.getEntity()));
            return simpleHttpResponse;
        }
    }

    private static String getErrorMessage(.HttpUriRequest request, .CloseableHttpResponse response) {
        String reason;
        String controllerHost = null;
        String controllerVersion = null;
        if (response.containsHeader("Pinot-Controller-Host")) {
            controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
            controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
        }
        .StatusLine statusLine = response.getStatusLine();
        try {
            reason = JsonUtils.stringToJsonNode(.EntityUtils.toString((.HttpEntity)response.getEntity())).get("error").asText();
        }
        catch (Exception e) {
            reason = "Failed to get reason";
        }
        String errorMessage = String.format("Got error status code: %d (%s) with reason: \"%s\" while sending request: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase(), reason, request.getURI());
        if (controllerHost != null) {
            errorMessage = String.format("%s to controller: %s, version: %s", errorMessage, controllerHost, controllerVersion);
        }
        return errorMessage;
    }

    public SimpleHttpResponse sendGetRequest(URI uri) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.constructGetRequest(uri));
    }

    public SimpleHttpResponse addSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getAddSchemaRequest(uri, schemaName, schemaFile));
    }

    public SimpleHttpResponse updateSchema(URI uri, String schemaName, File schemaFile) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUpdateSchemaRequest(uri, schemaName, schemaFile));
    }

    public SimpleHttpResponse uploadSegmentMetadata(URI uri, String segmentName, File segmentMetadataFile, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentMetadataRequest(uri, segmentName, segmentMetadataFile, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, segmentFile, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, File segmentFile) throws IOException, HttpErrorStatusException {
        return this.uploadSegment(uri, segmentName, segmentFile, null, null, 600000);
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getUploadSegmentRequest(uri, segmentName, inputStream, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse uploadSegment(URI uri, String segmentName, InputStream inputStream) throws IOException, HttpErrorStatusException {
        return this.uploadSegment(uri, segmentName, inputStream, null, null, 600000);
    }

    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSendSegmentUriRequest(uri, downloadUri, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse sendSegmentUri(URI uri, String downloadUri) throws IOException, HttpErrorStatusException {
        return this.sendSegmentUri(uri, downloadUri, null, null, 600000);
    }

    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString, @Nullable List<.Header> headers, @Nullable List<.NameValuePair> parameters, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSendSegmentJsonRequest(uri, jsonString, headers, parameters, socketTimeoutMs));
    }

    public SimpleHttpResponse sendSegmentJson(URI uri, String jsonString) throws IOException, HttpErrorStatusException {
        return this.sendSegmentJson(uri, jsonString, null, null, 600000);
    }

    public SimpleHttpResponse sendSegmentCompletionProtocolRequest(URI uri, int socketTimeoutMs) throws IOException, HttpErrorStatusException {
        return this.sendRequest(FileUploadDownloadClient.getSegmentCompletionProtocolRequest(uri, socketTimeoutMs));
    }

    public int downloadFile(URI uri, int socketTimeoutMs, File dest) throws IOException, HttpErrorStatusException {
        .HttpUriRequest request = FileUploadDownloadClient.getDownloadFileRequest(uri, socketTimeoutMs);
        try (.CloseableHttpResponse response = this._httpClient.execute(request);){
            .StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(FileUploadDownloadClient.getErrorMessage(request, response), statusCode);
            }
            .HttpEntity entity = response.getEntity();
            try (InputStream inputStream = response.getEntity().getContent();
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dest));){
                IOUtils.copyLarge(inputStream, outputStream);
            }
            long contentLength = entity.getContentLength();
            if (contentLength >= 0L) {
                long fileLength = dest.length();
                Preconditions.checkState(fileLength == contentLength, String.format("While downloading file with uri: %s, file length: %d does not match content length: %d", uri, fileLength, contentLength));
            }
            int n = statusCode;
            return n;
        }
    }

    public int downloadFile(URI uri, File dest) throws IOException, HttpErrorStatusException {
        return this.downloadFile(uri, 600000, dest);
    }

    @Override
    public void close() throws IOException {
        this._httpClient.close();
    }

    public static enum FileUploadType {
        URI,
        JSON,
        SEGMENT;


        public static FileUploadType getDefaultUploadType() {
            return SEGMENT;
        }
    }

    public static class QueryParameters {
        public static final String ENABLE_PARALLEL_PUSH_PROTECTION = "enableParallelPushProtection";
    }

    public static class CustomHeaders {
        public static final String UPLOAD_TYPE = "UPLOAD_TYPE";
        public static final String DOWNLOAD_URI = "DOWNLOAD_URI";
        public static final String SEGMENT_ZK_METADATA_CUSTOM_MAP_MODIFIER = "Pinot-SegmentZKMetadataCustomMapModifier";
        public static final String CRYPTER = "CRYPTER";
    }
}

