/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class HashUtil {
    public static int MIN_FASTUTIL_HASHSET_SIZE = 25;

    public static int getMinHashSetSize(int expected) {
        return Math.min(MIN_FASTUTIL_HASHSET_SIZE, expected);
    }

    public static long compute(IntBuffer buff) {
        buff.rewind();
        ByteBuffer bBuff = ByteBuffer.allocate(buff.array().length * 4);
        for (int i : buff.array()) {
            bBuff.putInt(i);
        }
        return HashUtil.compute(bBuff);
    }

    public static long compute(ByteBuffer buff) {
        return HashUtil.hash64(buff.array(), buff.array().length);
    }

    public static long hash64(byte[] data, int length) {
        return HashUtil.hash64(data, length, -512093083);
    }

    public static long hash64(byte[] data, int length, int seed) {
        long m = -4132994306676758123L;
        int r = 47;
        long h = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }
}

