/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.io.File;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.admin.TopicCommand;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServerStartable;
import org.I0Itec.zkclient.ZkClient;
import org.apache.pinot.$internal.org.apache.commons.io.FileUtils;

public class KafkaStarterUtils {
    public static final int DEFAULT_KAFKA_PORT = 19092;
    public static final int DEFAULT_BROKER_ID = 0;
    public static final String DEFAULT_ZK_STR = "localhost:2191/kafka";
    public static final String DEFAULT_KAFKA_BROKER = "localhost:19092";

    public static Properties getDefaultKafkaConfiguration() {
        Properties configuration = new Properties();
        KafkaStarterUtils.configureTopicDeletion(configuration, true);
        KafkaStarterUtils.configureHostName(configuration, "localhost");
        return configuration;
    }

    public static List<KafkaServerStartable> startServers(int brokerCount, int port, String zkStr, Properties configuration) {
        ArrayList<KafkaServerStartable> startables = new ArrayList<KafkaServerStartable>(brokerCount);
        for (int i = 0; i < brokerCount; ++i) {
            startables.add(KafkaStarterUtils.startServer(port + i, i, zkStr, "/tmp/kafka-" + Double.toHexString(Math.random()), configuration));
        }
        return startables;
    }

    public static KafkaServerStartable startServer(int port, int brokerId, String zkStr, Properties configuration) {
        return KafkaStarterUtils.startServer(port, brokerId, zkStr, "/tmp/kafka-" + Double.toHexString(Math.random()), configuration);
    }

    public static KafkaServerStartable startServer(int port, int brokerId, String zkStr, String logDirPath, Properties configuration) {
        int indexOfFirstSlash = zkStr.indexOf(47);
        if (indexOfFirstSlash != -1) {
            String bareZkUrl = zkStr.substring(0, indexOfFirstSlash);
            String zkNodePath = zkStr.substring(indexOfFirstSlash);
            ZkClient client = new ZkClient(bareZkUrl);
            client.createPersistent(zkNodePath, true);
            client.close();
        }
        File logDir = new File(logDirPath);
        logDir.mkdirs();
        KafkaStarterUtils.configureKafkaPort(configuration, port);
        KafkaStarterUtils.configureZkConnectionString(configuration, zkStr);
        KafkaStarterUtils.configureBrokerId(configuration, brokerId);
        KafkaStarterUtils.configureKafkaLogDirectory(configuration, logDir);
        configuration.put("zookeeper.session.timeout.ms", "60000");
        KafkaConfig config = new KafkaConfig((Map)configuration);
        KafkaServerStartable serverStartable = new KafkaServerStartable(config);
        serverStartable.startup();
        return serverStartable;
    }

    public static void configureSegmentSizeBytes(Properties properties, int segmentSize) {
        properties.put("log.segment.bytes", Integer.toString(segmentSize));
    }

    public static void configureLogRetentionSizeBytes(Properties properties, int logRetentionSizeBytes) {
        properties.put("log.retention.bytes", Integer.toString(logRetentionSizeBytes));
    }

    public static void configureKafkaLogDirectory(Properties configuration, File logDir) {
        configuration.put("log.dirs", logDir.getAbsolutePath());
    }

    public static void configureBrokerId(Properties configuration, int brokerId) {
        configuration.put("broker.id", Integer.toString(brokerId));
    }

    public static void configureZkConnectionString(Properties configuration, String zkStr) {
        configuration.put("zookeeper.connect", zkStr);
    }

    public static void configureKafkaPort(Properties configuration, int port) {
        configuration.put("port", Integer.toString(port));
    }

    public static void configureTopicDeletion(Properties configuration, boolean topicDeletionEnabled) {
        configuration.put("delete.topic.enable", Boolean.toString(topicDeletionEnabled));
    }

    public static void configureHostName(Properties configuration, String hostName) {
        configuration.put("host.name", hostName);
    }

    public static void stopServer(KafkaServerStartable serverStartable) {
        serverStartable.shutdown();
        FileUtils.deleteQuietly(new File((String)serverStartable.serverConfig().logDirs().apply(0)));
    }

    public static void createTopic(String kafkaTopic, String zkStr, int partitionCount) {
        KafkaStarterUtils.invokeTopicCommand(new String[]{"--create", "--zookeeper", zkStr, "--replication-factor", "1", "--partitions", Integer.toString(partitionCount), "--topic", kafkaTopic});
    }

    private static void invokeTopicCommand(String[] args) {
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
                if (perm.getName().startsWith("exitVM")) {
                    throw new SecurityException("System.exit is disabled");
                }
            }

            @Override
            public void checkPermission(Permission perm, Object context) {
                this.checkPermission(perm);
            }
        });
        try {
            TopicCommand.main((String[])args);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        System.setSecurityManager(null);
    }

    public static void deleteTopic(String kafkaTopic, String zkStr) {
        KafkaStarterUtils.invokeTopicCommand(new String[]{"--delete", "--zookeeper", zkStr, "--topic", kafkaTopic});
    }
}

