/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.SegmentName;

public class LLCUtils {
    public static Map<String, SortedSet<SegmentName>> sortSegmentsByStreamPartition(Set<String> segmentSet) {
        HashMap<String, SortedSet<SegmentName>> sortedSegmentsByStreamPartition = new HashMap<String, SortedSet<SegmentName>>();
        for (String segment : segmentSet) {
            if (!SegmentName.isLowLevelConsumerSegmentName(segment)) continue;
            LLCSegmentName segmentName = new LLCSegmentName(segment);
            String streamPartitionId = segmentName.getPartitionRange();
            TreeSet<LLCSegmentName> segmentsForPartition = (TreeSet<LLCSegmentName>)sortedSegmentsByStreamPartition.get(streamPartitionId);
            if (segmentsForPartition == null) {
                segmentsForPartition = new TreeSet<LLCSegmentName>();
                sortedSegmentsByStreamPartition.put(streamPartitionId, segmentsForPartition);
            }
            segmentsForPartition.add(segmentName);
        }
        return sortedSegmentsByStreamPartition;
    }
}

